/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnCompletionDefinition;

public class OnCompletionIssueTest
extends ContextTestSupport {
    public void testOnCompletionIssue() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedBodiesReceivedInAnyOrder(new Object[]{"finish", "stop", "ile", "markRollback"});
        MockEndpoint failed = this.getMockEndpoint("mock:failed");
        failed.expectedBodiesReceivedInAnyOrder(new Object[]{"faulted", "npe", "rollback"});
        this.template.sendBody("direct:input", (Object)"finish");
        this.template.sendBody("direct:input", (Object)"stop");
        this.template.sendBody("direct:input", (Object)"fault");
        this.template.sendBody("direct:input", (Object)"ile");
        this.template.sendBody("direct:input", (Object)"markRollback");
        try {
            this.template.sendBody("direct:input", (Object)"npe");
            OnCompletionIssueTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionIssueTest.assertEquals((String)"Darn NPE", (String)e.getCause().getMessage());
        }
        try {
            this.template.sendBody("direct:input", (Object)"rollback");
            OnCompletionIssueTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionIssueTest.assertIsInstanceOf(RollbackExchangeException.class, e.getCause());
        }
        this.setAssertPeriod(2000L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.onCompletion().onFailureOnly().parallelProcessing().log("failing ${body}")).to("mock:failed");
                ((OnCompletionDefinition)this.onCompletion().onCompleteOnly().parallelProcessing().log("completing ${body}")).to("mock:complete");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:input").onException(IllegalArgumentException.class).handled(true).end().choice().when((Predicate)this.simple("${body} == 'stop'")).log("stopping")).stop()).when((Predicate)this.simple("${body} == 'fault'")).log("faulting")).setFaultBody((Expression)this.constant("faulted"))).when((Predicate)this.simple("${body} == 'ile'")).log("excepting")).throwException((Exception)new IllegalArgumentException("Exception requested"))).when((Predicate)this.simple("${body} == 'npe'")).log("excepting")).throwException((Exception)new NullPointerException("Darn NPE"))).when((Predicate)this.simple("${body} == 'rollback'")).log("rollback")).rollback()).when((Predicate)this.simple("${body} == 'markRollback'")).log("markRollback")).markRollbackOnly()).end().log("finishing").to("mock:end");
            }
        };
    }
}

