/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class MulticastShareUnitOfWorkOnExceptionHandledFalseIssueTest
extends ContextTestSupport {
    public void testMulticast() throws Exception {
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            MulticastShareUnitOfWorkOnExceptionHandledFalseIssueTest.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            IllegalArgumentException cause = MulticastShareUnitOfWorkOnExceptionHandledFalseIssueTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            MulticastShareUnitOfWorkOnExceptionHandledFalseIssueTest.assertEquals((String)"Forced", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(false).to("mock:a");
                ((MulticastDefinition)this.from("direct:start").multicast().shareUnitOfWork().stopOnException().to("direct:b")).end().to("mock:result");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

