/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

public class AdviceWithPolicyTest
extends ContextTestSupport {
    public void testAdviceWithPolicy() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        route.adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveById("b").after().to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy((Policy)new MyPolicy()).to("mock:a")).id("a")).to("mock:b")).id("b");
            }
        };
    }

    private static final class MyPolicy
    implements Policy {
        private MyPolicy() {
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        }

        public Processor wrap(RouteContext routeContext, Processor processor) {
            return processor;
        }
    }
}

