/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class ShutdownGracefulNoAutoStartedRoutesTest
extends ContextTestSupport {
    public void testShutdownGraceful() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.context.startRoute("bar");
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        ShutdownGracefulNoAutoStartedRoutesTest.assertTrue((String)"Route foo should be stopped", (boolean)this.context.getRouteStatus("foo").isStopped());
        ShutdownGracefulNoAutoStartedRoutesTest.assertTrue((String)"Route bar should be stopped", (boolean)this.context.getRouteStatus("bar").isStopped());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                this.from("direct:bar").routeId("bar").noAutoStartup().to("mock:bar");
            }
        };
    }
}

