/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.MySerialBean;

public class SerializationDataFormatTest
extends ContextTestSupport {
    public void testSerialization() throws Exception {
        MySerialBean bean = new MySerialBean();
        bean.setId(123);
        bean.setName("Donald");
        Object data = this.template.requestBody("direct:marshal", (Object)bean);
        SerializationDataFormatTest.assertNotNull((Object)data);
        Object out = this.template.requestBody("direct:unmarshal", data);
        SerializationDataFormatTest.assertNotNull((Object)out);
        MySerialBean outBean = (MySerialBean)this.context.getTypeConverter().convertTo(MySerialBean.class, out);
        SerializationDataFormatTest.assertNotNull((Object)outBean);
        SerializationDataFormatTest.assertEquals((int)123, (int)outBean.getId());
        SerializationDataFormatTest.assertEquals((String)"Donald", (String)outBean.getName());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:unmarshal").unmarshal().serialization();
                this.from("direct:marshal").marshal().serialization();
            }
        };
    }
}

