/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class PendingExchangesTwoRouteShutdownGracefulTest
extends ContextTestSupport {
    private static String foo = "";
    private static String bar = "";
    private static CountDownLatch latch = new CountDownLatch(2);

    public void testShutdownGraceful() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.template.sendBody("seda:bar", (Object)"A");
        this.template.sendBody("seda:bar", (Object)"B");
        this.template.sendBody("seda:bar", (Object)"C");
        this.template.sendBody("seda:bar", (Object)"D");
        this.template.sendBody("seda:bar", (Object)"E");
        this.assertMockEndpointsSatisfied();
        PendingExchangesTwoRouteShutdownGracefulTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.context.stop();
        PendingExchangesTwoRouteShutdownGracefulTest.assertEquals((String)"Should graceful shutdown", (String)"ABCDE", (String)foo);
        PendingExchangesTwoRouteShutdownGracefulTest.assertEquals((String)"Should graceful shutdown", (String)"ABCDE", (String)bar);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).delay(1000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                        latch.countDown();
                    }
                });
                ((RouteDefinition)this.from("seda:bar").to("mock:bar")).delay(500L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        bar = bar + (String)exchange.getIn().getBody(String.class);
                        latch.countDown();
                    }
                });
            }
        };
    }
}

