/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.DefaultCamelContext;

public class EipDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("from");
        this.log.info(json);
        EipDocumentationTest.assertNotNull((String)"Should have found json for from", (Object)json);
        EipDocumentationTest.assertTrue((boolean)json.contains("\"name\": \"from\""));
        EipDocumentationTest.assertTrue((boolean)json.contains("\"uri\": { \"kind\": \"attribute\""));
        EipDocumentationTest.assertTrue((boolean)json.contains("\"ref\": { \"kind\": \"attribute\""));
    }

    public void testSplitDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("split");
        this.log.info(json);
        EipDocumentationTest.assertNotNull((String)"Should have found json for split", (Object)json);
        EipDocumentationTest.assertTrue((boolean)json.contains("\"name\": \"split\""));
        EipDocumentationTest.assertTrue((boolean)json.contains("If enabled then processing each splitted messages occurs concurrently."));
        EipDocumentationTest.assertTrue((boolean)json.contains("\"outputs\": { \"kind\": \"element\", \"required\": \"true\", \"type\": \"array\", \"javaType\""));
    }

    public void testSimpleDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("simple");
        this.log.info(json);
        EipDocumentationTest.assertNotNull((String)"Should have found json for simple", (Object)json);
        EipDocumentationTest.assertTrue((boolean)json.contains("\"label\": \"language,core,java\""));
        EipDocumentationTest.assertTrue((boolean)json.contains("\"name\": \"simple\""));
    }

    public void testFailOverDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("failover");
        this.log.info(json);
        EipDocumentationTest.assertNotNull((String)"Should have found json for failover", (Object)json);
        EipDocumentationTest.assertTrue((boolean)json.contains("\"name\": \"failover\""));
        EipDocumentationTest.assertTrue((boolean)json.contains("\"exception\": { \"kind\": \"element\", \"required\": \"false\", \"type\": \"array\", \"javaType\": \"java.util.List<java.lang.String>\", \"deprecated\": \"false\""));
    }

    public void testNotFound() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("unknown");
        EipDocumentationTest.assertNull((String)"Should not have found json for unknown", (Object)json);
    }
}

