/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;

public class DefaultProducerCacheTest
extends ContextTestSupport {
    private final AtomicInteger stopCounter = new AtomicInteger();
    private final AtomicInteger shutdownCounter = new AtomicInteger();

    public void testCacheProducerAcquireAndRelease() throws Exception {
        ProducerCache cache = new ProducerCache((Object)this, (CamelContext)this.context);
        cache.start();
        DefaultProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        for (int i = 0; i < 1003; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            Producer p = cache.acquireProducer(e);
            cache.releaseProducer(e, p);
        }
        DefaultProducerCacheTest.assertEquals((String)"Size should be 1000", (int)1000, (int)cache.size());
        cache.stop();
    }

    public void testCacheStopExpired() throws Exception {
        ProducerCache cache = new ProducerCache((Object)this, (CamelContext)this.context, 5);
        cache.start();
        DefaultProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        for (int i = 0; i < 8; ++i) {
            MyEndpoint e = new MyEndpoint(true, i);
            Producer p = cache.acquireProducer((Endpoint)e);
            cache.releaseProducer((Endpoint)e, p);
        }
        DefaultProducerCacheTest.assertEquals((String)"Size should be 5", (int)5, (int)cache.size());
        DefaultProducerCacheTest.assertEquals((int)3, (int)this.stopCounter.get());
        cache.stop();
        DefaultProducerCacheTest.assertEquals((int)8, (int)this.stopCounter.get());
    }

    public void testReleaseProducerInvokesStopAndShutdownByNonSingletonProducers() throws Exception {
        ProducerCache cache = new ProducerCache((Object)this, (CamelContext)this.context, 1);
        cache.start();
        DefaultProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        for (int i = 0; i < 3; ++i) {
            MyEndpoint e = new MyEndpoint(false, i);
            Producer p = cache.acquireProducer((Endpoint)e);
            cache.releaseProducer((Endpoint)e, p);
        }
        DefaultProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        DefaultProducerCacheTest.assertEquals((int)3, (int)this.stopCounter.get());
        DefaultProducerCacheTest.assertEquals((int)3, (int)this.shutdownCounter.get());
        cache.stop();
        DefaultProducerCacheTest.assertEquals((int)3, (int)this.stopCounter.get());
        DefaultProducerCacheTest.assertEquals((int)3, (int)this.shutdownCounter.get());
    }

    public void testExtendedStatistics() throws Exception {
        ProducerCache cache = new ProducerCache((Object)this, (CamelContext)this.context, 5);
        cache.setExtendedStatistics(true);
        cache.start();
        DefaultProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        MyEndpoint e = new MyEndpoint(true, 1);
        Producer p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        e = new MyEndpoint(true, 1);
        p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        e = new MyEndpoint(true, 2);
        p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        e = new MyEndpoint(true, 2);
        p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        e = new MyEndpoint(true, 2);
        p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        e = new MyEndpoint(true, 3);
        p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        e = new MyEndpoint(true, 4);
        p = cache.acquireProducer((Endpoint)e);
        cache.releaseProducer((Endpoint)e, p);
        DefaultProducerCacheTest.assertEquals((String)"Size should be 4", (int)4, (int)cache.size());
        EndpointUtilizationStatistics stats = cache.getEndpointUtilizationStatistics();
        DefaultProducerCacheTest.assertEquals((int)4, (int)stats.size());
        Map recent = stats.getStatistics();
        DefaultProducerCacheTest.assertEquals((long)2L, (long)((Long)recent.get("my://1")));
        DefaultProducerCacheTest.assertEquals((long)3L, (long)((Long)recent.get("my://2")));
        DefaultProducerCacheTest.assertEquals((long)1L, (long)((Long)recent.get("my://3")));
        DefaultProducerCacheTest.assertEquals((long)1L, (long)((Long)recent.get("my://4")));
        DefaultProducerCacheTest.assertNull(recent.get("my://5"));
        cache.stop();
    }

    private final class MyProducer
    extends DefaultProducer {
        public MyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
        }

        protected void doStop() throws Exception {
            DefaultProducerCacheTest.this.stopCounter.incrementAndGet();
        }

        protected void doShutdown() throws Exception {
            DefaultProducerCacheTest.this.shutdownCounter.incrementAndGet();
        }
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private final boolean isSingleton;
        private final int number;

        private MyEndpoint(boolean isSingleton, int number) {
            this.isSingleton = isSingleton;
            this.number = number;
        }

        public Producer createProducer() throws Exception {
            return new MyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return this.isSingleton;
        }

        public String getEndpointUri() {
            return "my://" + this.number;
        }
    }
}

