/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;

public class DefaultExecutorServiceManagerTest
extends ContextTestSupport {
    public void testResolveThreadNameDefaultPattern() throws Exception {
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.startsWith("Camel (" + this.context.getName() + ") thread "));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.endsWith("foo"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.startsWith("Camel (" + this.context.getName() + ") thread "));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.endsWith("bar"));
    }

    public void testGetThreadNameCustomPattern() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("##counter# - #name#");
        DefaultExecutorServiceManagerTest.assertEquals((String)"##counter# - #name#", (String)this.context.getExecutorServiceManager().getThreadNamePattern());
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.startsWith("#"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.endsWith(" - foo"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.startsWith("#"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternCamelId() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("##camelId# - ##counter# - #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.startsWith("#" + this.context.getName() + " - #"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.endsWith(" - foo"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.startsWith("#" + this.context.getName() + " - #"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternWithDollar() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("Hello - #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo$bar");
        DefaultExecutorServiceManagerTest.assertEquals((String)"Hello - foo$bar", (String)foo);
    }

    public void testGetThreadNameCustomPatternLongName() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("##counter# - #longName#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo?beer=Carlsberg");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.startsWith("#"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.endsWith(" - foo?beer=Carlsberg"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.startsWith("#"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternWithParameters() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("##counter# - #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo?beer=Carlsberg");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.startsWith("#"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)foo.endsWith(" - foo"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.startsWith("#"));
        DefaultExecutorServiceManagerTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternNoCounter() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("Cool #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertEquals((String)"Cool foo", (String)foo);
        DefaultExecutorServiceManagerTest.assertEquals((String)"Cool bar", (String)bar);
    }

    public void testGetThreadNameCustomPatternInvalid() throws Exception {
        this.context.getExecutorServiceManager().setThreadNamePattern("Cool #xxx#");
        try {
            this.context.getExecutorServiceManager().resolveThreadName("foo");
            DefaultExecutorServiceManagerTest.fail((String)"Should thrown an exception");
        }
        catch (IllegalArgumentException e) {
            DefaultExecutorServiceManagerTest.assertEquals((String)"Pattern is invalid: Cool #xxx#", (String)e.getMessage());
        }
        this.context.getExecutorServiceManager().setThreadNamePattern("Camel Thread #counter# - #name#");
    }

    public void testDefaultThreadPool() throws Exception {
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceManagerTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceManagerTest.assertEquals((int)10, (int)executor.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)20, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)60L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)1000, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testDefaultUnboundedQueueThreadPool() throws Exception {
        ThreadPoolProfile custom = new ThreadPoolProfile("custom");
        custom.setPoolSize(Integer.valueOf(10));
        custom.setMaxPoolSize(Integer.valueOf(30));
        custom.setKeepAliveTime(Long.valueOf(50L));
        custom.setMaxQueueSize(Integer.valueOf(Integer.MAX_VALUE));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(custom);
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceManagerTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceManagerTest.assertEquals((int)10, (int)executor.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)30, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)50L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)Integer.MAX_VALUE, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testDefaultNoMaxQueueThreadPool() throws Exception {
        ThreadPoolProfile custom = new ThreadPoolProfile("custom");
        custom.setPoolSize(Integer.valueOf(10));
        custom.setMaxPoolSize(Integer.valueOf(30));
        custom.setKeepAliveTime(Long.valueOf(50L));
        custom.setMaxQueueSize(Integer.valueOf(0));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(custom);
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceManagerTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceManagerTest.assertEquals((int)10, (int)executor.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)30, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)50L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)0, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testCustomDefaultThreadPool() throws Exception {
        ThreadPoolProfile custom = new ThreadPoolProfile("custom");
        custom.setKeepAliveTime(Long.valueOf(20L));
        custom.setMaxPoolSize(Integer.valueOf(40));
        custom.setPoolSize(Integer.valueOf(5));
        custom.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(custom);
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceManagerTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)executor.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)40, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)20L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)2000, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testGetThreadPoolProfile() throws Exception {
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        DefaultExecutorServiceManagerTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
    }

    public void testTwoGetThreadPoolProfile() throws Exception {
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        ThreadPoolProfile bar = new ThreadPoolProfile("bar");
        bar.setKeepAliveTime(Long.valueOf(40L));
        bar.setMaxPoolSize(Integer.valueOf(5));
        bar.setPoolSize(Integer.valueOf(1));
        bar.setMaxQueueSize(Integer.valueOf(100));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(bar);
        DefaultExecutorServiceManagerTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        DefaultExecutorServiceManagerTest.assertSame((Object)bar, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("bar"));
        DefaultExecutorServiceManagerTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceManagerTest.assertFalse((boolean)this.context.getExecutorServiceManager().getThreadPoolProfile("foo").isDefaultProfile());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)this.context.getExecutorServiceManager().getThreadPoolProfile("bar").isDefaultProfile());
    }

    public void testGetThreadPoolProfileInheritDefaultValues() throws Exception {
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setMaxPoolSize(Integer.valueOf(40));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        DefaultExecutorServiceManagerTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceManager().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        DefaultExecutorServiceManagerTest.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)10, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((String)"CallerRuns", (String)tp.getRejectedExecutionHandler().toString());
    }

    public void testGetThreadPoolProfileInheritCustomDefaultValues() throws Exception {
        ThreadPoolProfile newDefault = new ThreadPoolProfile("newDefault");
        newDefault.setKeepAliveTime(Long.valueOf(30L));
        newDefault.setMaxPoolSize(Integer.valueOf(50));
        newDefault.setPoolSize(Integer.valueOf(5));
        newDefault.setMaxQueueSize(Integer.valueOf(2000));
        newDefault.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(newDefault);
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setMaxPoolSize(Integer.valueOf(25));
        foo.setPoolSize(Integer.valueOf(1));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        DefaultExecutorServiceManagerTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceManager().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        DefaultExecutorServiceManagerTest.assertEquals((int)25, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)30L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((String)"Abort", (String)tp.getRejectedExecutionHandler().toString());
    }

    public void testGetThreadPoolProfileInheritCustomDefaultValues2() throws Exception {
        ThreadPoolProfile newDefault = new ThreadPoolProfile("newDefault");
        newDefault.setMaxPoolSize(Integer.valueOf(50));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(newDefault);
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setPoolSize(Integer.valueOf(1));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        DefaultExecutorServiceManagerTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceManager().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        DefaultExecutorServiceManagerTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)50, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((String)"CallerRuns", (String)tp.getRejectedExecutionHandler().toString());
    }

    public void testNewThreadPoolProfile() throws Exception {
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "Cool", foo);
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)20L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewThreadPoolProfileById() throws Exception {
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "Cool", "foo");
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)20L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewThreadPoolMinMax() throws Exception {
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "Cool", 5, 10);
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)10, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewFixedThreadPool() throws Exception {
        ExecutorService pool = this.context.getExecutorServiceManager().newFixedThreadPool((Object)this, "Cool", 5);
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((String)"keepAliveTime", (long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((String)"maximumPoolSize", (int)5, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewSingleThreadExecutor() throws Exception {
        ExecutorService pool = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "Cool");
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((String)"keepAliveTime", (long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((String)"maximumPoolSize", (int)1, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewScheduledThreadPool() throws Exception {
        ScheduledExecutorService pool = this.context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "Cool", 5);
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        SizedScheduledExecutorService tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(SizedScheduledExecutorService.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewSingleThreadScheduledExecutor() throws Exception {
        ScheduledExecutorService pool = this.context.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "Cool");
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        SizedScheduledExecutorService tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(SizedScheduledExecutorService.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewCachedThreadPool() throws Exception {
        ExecutorService pool = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "Cool");
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)0, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewScheduledThreadPoolProfileById() throws Exception {
        DefaultExecutorServiceManagerTest.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        ScheduledExecutorService pool = this.context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "Cool", "foo");
        DefaultExecutorServiceManagerTest.assertNotNull((Object)pool);
        SizedScheduledExecutorService tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(SizedScheduledExecutorService.class, pool);
        DefaultExecutorServiceManagerTest.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceManagerTest.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceManagerTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceManagerTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceManagerTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testNewThread() throws Exception {
        Thread thread = this.context.getExecutorServiceManager().newThread("Cool", new Runnable(){

            @Override
            public void run() {
            }
        });
        DefaultExecutorServiceManagerTest.assertNotNull((Object)thread);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)thread.isDaemon());
        DefaultExecutorServiceManagerTest.assertTrue((boolean)thread.getName().contains("Cool"));
    }

    public void xxxTestLongShutdownOfThreadPool() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutorService pool = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "Cool");
        pool.execute(new Runnable(){

            @Override
            public void run() {
                DefaultExecutorServiceManagerTest.this.log.info("Starting thread");
                try {
                    latch.await(42L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DefaultExecutorServiceManagerTest.this.log.info("Existing thread");
            }
        });
        Thread.sleep(3000L);
        this.context.getExecutorServiceManager().shutdown(pool);
        DefaultExecutorServiceManagerTest.assertTrue((boolean)pool.isShutdown());
        DefaultExecutorServiceManagerTest.assertTrue((boolean)pool.isTerminated());
    }
}

