/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultExchangeHolder;

public class DefaultExchangeHolderTest
extends ContextTestSupport {
    private String id;

    public void testMarshal() throws Exception {
        DefaultExchangeHolder holder = this.createHolder(true);
        DefaultExchangeHolderTest.assertNotNull((Object)holder);
        DefaultExchangeHolderTest.assertNotNull((Object)holder.toString());
    }

    public void testNoProperties() throws Exception {
        DefaultExchangeHolder holder = this.createHolder(false);
        DefaultExchangeHolderTest.assertNotNull((Object)holder);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        DefaultExchangeHolderTest.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)"Bye World", (Object)exchange.getOut().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)123, (Object)exchange.getIn().getHeader("foo"));
        DefaultExchangeHolderTest.assertNull((Object)exchange.getProperty("bar"));
    }

    public void testUnmarshal() throws Exception {
        this.id = null;
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)this.createHolder(true));
        DefaultExchangeHolderTest.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)"Bye World", (Object)exchange.getOut().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)123, (Object)exchange.getIn().getHeader("foo"));
        DefaultExchangeHolderTest.assertEquals((Object)"Hi Camel", (Object)exchange.getIn().getHeader("CamelFoo"));
        DefaultExchangeHolderTest.assertEquals((Object)444, (Object)exchange.getProperty("bar"));
        DefaultExchangeHolderTest.assertEquals((Object)555, (Object)exchange.getProperty("CamelBar"));
        DefaultExchangeHolderTest.assertEquals((String)this.id, (String)exchange.getExchangeId());
    }

    public void testSkipNonSerializableData() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", (Object)new MyFoo("Tiger"));
        exchange.getIn().setHeader("Bar", (Object)123);
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        DefaultExchangeHolderTest.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        DefaultExchangeHolderTest.assertNull((Object)exchange.getIn().getHeader("Foo"));
    }

    public void testSkipNonSerializableDataFromList() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("I am okay");
        list.add(new MyFoo("Tiger"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", list);
        exchange.getIn().setHeader("Bar", (Object)123);
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        DefaultExchangeHolderTest.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        DefaultExchangeHolderTest.assertNull((Object)exchange.getIn().getHeader("Foo"));
    }

    public void testSkipNonSerializableDataFromMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("A", "I am okay");
        map.put("B", new MyFoo("Tiger"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", map);
        exchange.getIn().setHeader("Bar", (Object)123);
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        DefaultExchangeHolderTest.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        DefaultExchangeHolderTest.assertNull((Object)exchange.getIn().getHeader("Foo"));
    }

    public void testCaughtException() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("I am okay");
        list.add(new MyFoo("Tiger"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", list);
        exchange.getIn().setHeader("Bar", (Object)123);
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("Forced"));
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        DefaultExchangeHolderTest.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        DefaultExchangeHolderTest.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        DefaultExchangeHolderTest.assertNull((Object)exchange.getIn().getHeader("Foo"));
        DefaultExchangeHolderTest.assertNotNull((Object)exchange.getProperty("CamelExceptionCaught"));
        DefaultExchangeHolderTest.assertEquals((String)"Forced", (String)((Exception)exchange.getProperty("CamelExceptionCaught", Exception.class)).getMessage());
    }

    public void testFileNotSupported() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new File("src/test/resources/log4j.properties"));
        try {
            DefaultExchangeHolder.marshal((Exchange)exchange);
            DefaultExchangeHolderTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeExchangeException runtimeExchangeException) {
            // empty catch block
        }
    }

    private DefaultExchangeHolder createHolder(boolean includeProperties) {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        this.id = exchange.getExchangeId();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("foo", (Object)123);
        exchange.getIn().setHeader("CamelFoo", (Object)"Hi Camel");
        exchange.setProperty("bar", (Object)444);
        exchange.setProperty("CamelBar", (Object)555);
        exchange.getOut().setBody((Object)"Bye World");
        return DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)includeProperties);
    }

    private static final class MyFoo {
        private String foo;

        private MyFoo(String foo) {
            this.foo = foo;
        }

        public String getFoo() {
            return this.foo;
        }
    }
}

