/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;

public class CamelContextTrackerTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContainerSet() throws Exception {
        MyContextTracker tracker = new MyContextTracker();
        DefaultCamelContext camel1 = new DefaultCamelContext();
        DefaultCamelContext camel2 = new DefaultCamelContext();
        CamelContextTrackerTest.assertEquals((int)0, (int)tracker.names.size());
        try {
            tracker.open();
            CamelContextTrackerTest.assertEquals((int)0, (int)tracker.names.size());
            DefaultCamelContext camel3 = new DefaultCamelContext();
            CamelContextTrackerTest.assertEquals((int)1, (int)tracker.names.size());
            CamelContextTrackerTest.assertEquals((String)camel3.getName(), (String)((String)tracker.names.get(0)));
            camel1.stop();
            camel2.stop();
            camel3.stop();
            CamelContextTrackerTest.assertEquals((int)0, (int)tracker.names.size());
        }
        finally {
            tracker.close();
        }
    }

    private final class MyContextTracker
    extends CamelContextTracker {
        private List<String> names = new ArrayList<String>();

        private MyContextTracker() {
        }

        public void contextCreated(CamelContext camelContext) {
            camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

                public void onContextStop(CamelContext context) {
                    MyContextTracker.this.names.remove(context.getName());
                }
            });
            this.names.add(camelContext.getName());
        }
    }
}

