/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class XsltComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        XsltComponent comp = (XsltComponent)this.context.getComponent("xslt", XsltComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("xslt:foo?deleteOutputFile=true");
        XsltComponentConfigurationAndDocumentationTest.assertEquals((Object)"true", (Object)conf.getParameter("deleteOutputFile"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        XsltComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        XsltComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"resourceUri\": { \"kind\": \"path\", \"group\": \"producer\", \"required\": \"true\""));
        XsltComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"allowStAX\": { \"kind\": \"parameter\", \"group\": \"producer\", \"type\": \"boolean\""));
        XsltComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"transformerFactoryClass\": { \"kind\": \"parameter\", \"group\": \"advanced\", \"label\": \"advanced\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("xslt");
        XsltComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

