/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXSourceLogBodyTest
extends ContextTestSupport {
    public void testSAXSource() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)new File("src/test/resources/xslt/staff/staff.xml"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").streamCaching().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        byte[] data = (byte[])exchange.getIn().getBody(byte[].class);
                        InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, (Object)data);
                        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                        exchange.getIn().setBody((Object)new SAXSource(xmlReader, new InputSource(is)));
                    }
                })).log(LoggingLevel.WARN, "${body}")).to("xslt:xslt/common/staff_template.xsl")).to("log:result")).to("mock:result");
            }
        };
    }
}

