/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;

public class VmInOutChainedTimeoutTest
extends AbstractVmTestSupport {
    public void testVmInOutChainedTimeout() throws Exception {
        StopWatch watch = new StopWatch();
        try {
            this.template2.requestBody("vm:a?timeout=1000", (Object)"Hello World");
            VmInOutChainedTimeoutTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ExchangeTimedOutException cause = VmInOutChainedTimeoutTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause());
            VmInOutChainedTimeoutTest.assertEquals((long)200L, (long)cause.getTimeout());
        }
        long delta = watch.stop();
        VmInOutChainedTimeoutTest.assertTrue((String)("Should be faster than 1 sec, was: " + delta), (delta < 1100L ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("vm:b").to("mock:b")).delay(500L).transform().constant((Object)"Bye World");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((RouteDefinition)((RouteDefinition)this.from("vm:a").to("mock:a")).to("vm:b?timeout=200")).to("mock:a2");
            }
        };
    }
}

