/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.net.URL;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.PropertyPlaceholderDelegateRegistry;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.validation.CatalogLSResourceResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;

public class ValidatorWithResourceResolverRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<report xmlns='http://foo.com/report' xmlns:rb='http://foo.com/report-base'><author><rb:name>Knuth</rb:name></author><content><rb:chapter><rb:subject></rb:subject><rb:abstract></rb:abstract><rb:body></rb:body></rb:chapter></content></report>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<report xmlns='http://foo.com/report' xmlns:rb='http://foo.com/report-base'><author><rb:name>Knuth</rb:name></author></report>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
        CatalogResolver catalogResolver = new CatalogResolver(true);
        URL catalogUrl = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.context.getClassResolver(), (String)"org/apache/camel/component/validator/catalog.cat");
        catalogResolver.getCatalog().parseCatalog(catalogUrl);
        CatalogLSResourceResolver resourceResolver = new CatalogLSResourceResolver(catalogResolver);
        JndiRegistry registry = (JndiRegistry)((PropertyPlaceholderDelegateRegistry)this.context.getRegistry()).getRegistry();
        registry.bind("resourceResolver", (Object)resourceResolver);
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/report.xsd?resourceResolver=#resourceResolver")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

