/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.OptionsVerbDefinition;
import org.apache.camel.model.rest.RestDefinition;

public class FromRestOptionsTest
extends ContextTestSupport {
    static final String ALLOWS = "HEAD,GET,PUT,POST,DELETE,OPTIONS";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testRestOptionsModel() throws Exception {
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestOptionsTest.assertNotNull((Object)rest);
        FromRestOptionsTest.assertEquals((String)"/say/hello", (String)rest.getPath());
        FromRestOptionsTest.assertEquals((int)1, (int)rest.getVerbs().size());
        FromRestOptionsTest.assertIsInstanceOf(OptionsVerbDefinition.class, rest.getVerbs().get(0));
        Exchange out = this.template.request("seda:options-say-hello", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Me");
            }
        });
        this.assertMockEndpointsSatisfied();
        FromRestOptionsTest.assertNotNull((Object)out);
        FromRestOptionsTest.assertEquals((Object)out.getOut().getHeader("Allow"), (Object)ALLOWS);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                ((RouteDefinition)this.rest("/say/hello").options().route().setHeader("CamelHttpResponseCode", (Expression)this.constant(200))).setHeader("Allow", (Expression)this.constant(FromRestOptionsTest.ALLOWS));
            }
        };
    }
}

