/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ProcessorDefinition;

public class PropertiesComponentSetHeaderSimpleTest
extends ContextTestSupport {
    public void testPropertiesAndSimple() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"http://mycoolserver/myapp");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "app", (Object)"myapp");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setCamelContext(context);
        pc.setLocation("classpath:org/apache/camel/component/properties/cheese.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("direct:start").setHeader("foo").simple("{{cheese.server}}/${header.app}")).to("mock:result");
            }
        };
    }
}

