/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentFunctionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testFunction() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.addFunction((PropertiesFunction)new MyFunction());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:{{sys:os.name}}")).to("{{beer:FOO}}")).to("{{beer:BAR}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyFunction
    implements PropertiesFunction {
        public String getName() {
            return "beer";
        }

        public String apply(String remainder) {
            return "mock:" + remainder.toLowerCase();
        }
    }
}

