/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class LogInputStreamTest
extends ContextTestSupport {
    public void testA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:a");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:a", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    public void testB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:b");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).convertToString().isEqualTo((Object)"Hello World");
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:b", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    public void testC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:c");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:c", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    public void testD() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:d");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:d", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").to("log:a")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").to("log:b?showStreams=true")).to("mock:b");
                ((RouteDefinition)this.from("direct:c").streamCaching().to("log:c")).to("mock:c");
                ((RouteDefinition)this.from("direct:d").streamCaching().to("log:d?showStreams=true")).to("mock:d");
            }
        };
    }
}

