/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerPollManyFilesTest
extends ContextTestSupport {
    private static final int FILES = 200;

    @Override
    protected void setUp() throws Exception {
        if (FileConsumerPollManyFilesTest.isPlatform("windows")) {
            return;
        }
        FileConsumerPollManyFilesTest.deleteDirectory("target/manyfiles");
        super.setUp();
        for (int i = 0; i < 200; ++i) {
            this.template.sendBodyAndHeader("file:target/manyfiles", (Object)("Message " + i), "CamelFileName", (Object)("file-" + i + ".txt"));
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPollManyFiles() throws Exception {
        if (FileConsumerPollManyFilesTest.isPlatform("windows")) {
            return;
        }
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/manyfiles?delete=true").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(200);
        this.assertMockEndpointsSatisfied();
    }
}

