/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FromFileMoveDoneCustomHeaderTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FromFileMoveDoneCustomHeaderTest.deleteDirectory("target/inbox");
        FromFileMoveDoneCustomHeaderTest.deleteDirectory("target/outbox");
        super.setUp();
    }

    public void testMoveDoneCustomHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/outbox/hello.txt");
        mock.expectedFileExists("target/inbox/dones/mydone.txt");
        this.template.sendBodyAndHeader("file:target/inbox", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file:target/inbox?move=${header.bar}").setHeader("bar", (Expression)this.constant("dones/mydone.txt"))).transform((Expression)this.constant("Bye World"))).to(new String[]{"mock:result", "file:target/outbox"});
            }
        };
    }
}

