/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProduceAppendTest
extends ContextTestSupport {
    public void testAppendText() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/test-file-append/hello.txt", "Hello World");
        this.template.sendBody("direct:start", (Object)" World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        FileProduceAppendTest.deleteDirectory("target/test-file-append");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/test-file-append", (Object)"Hello", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/test-file-append", (Object)" World", "CamelFileName", (Object)"world.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeader("CamelFileName", (Expression)this.constant("hello.txt"))).to(new String[]{"file://target/test-file-append?fileExist=Append", "mock:result"});
            }
        };
    }
}

