/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileMarkerFileRecursiveDoNotDeleteOldLockFilesTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FileMarkerFileRecursiveDoNotDeleteOldLockFilesTest.deleteDirectory("target/oldlock");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"locked", "CamelFileName", (Object)"hello.txt.camelLock");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/oldlock/foo", (Object)"locked", "CamelFileName", (Object)"gooday.txt.camelLock");
        this.template.sendBodyAndHeader("file:target/oldlock/foo", (Object)"Goodday World", "CamelFileName", (Object)"gooday.txt");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"New World", "CamelFileName", (Object)"new.txt");
    }

    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"New World"});
        mock.setResultMinimumWaitTime(1000L);
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/oldlock?readLockDeleteOrphanLockFiles=false&recursive=true").routeId("foo").noAutoStartup().convertBodyTo(String.class)).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

