/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerMoveExpressionTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerMoveExpressionTest.deleteDirectory("target/filelanguage");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myguidgenerator", (Object)new MyGuidGenerator());
        return jndi;
    }

    public void testRenameToId() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/filelanguage/?exclude=.*bak&move=${id}.bak").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/filelanguage/", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        String id = ((Exchange)mock.getExchanges().get(0)).getIn().getMessageId();
        File file = new File("target/filelanguage/" + id + ".bak");
        FileConsumerMoveExpressionTest.assertTrue((String)"File should have been renamed", (boolean)file.exists());
    }

    public void testRenameToComplexWithId() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/filelanguage/?exclude=.*bak&move=backup-${id}-${file:name.noext}.bak").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader("file://target/filelanguage/", (Object)"Bye World", "CamelFileName", (Object)"report2.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        String id = ((Exchange)mock.getExchanges().get(0)).getIn().getMessageId();
        File file = new File("target/filelanguage/backup-" + id + "-report2.bak");
        FileConsumerMoveExpressionTest.assertTrue((String)"File should have been renamed", (boolean)file.exists());
    }

    public void testRenameToBean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/filelanguage/?exclude=.*bak&move=backup/${bean:myguidgenerator.guid}.txt").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Big World"});
        mock.expectedFileExists("target/filelanguage/backup/123.txt", "Bye Big World");
        this.template.sendBodyAndHeader("file://target/filelanguage/", (Object)"Bye Big World", "CamelFileName", (Object)"report3.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testRenameToSiblingFolder() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/filelanguage/?exclude=.*bak&move=../backup/${file:name}.bak").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Big World"});
        mock.expectedFileExists("target/backup/report4.txt.bak");
        this.template.sendBodyAndHeader("file://target/filelanguage/", (Object)"Hello Big World", "CamelFileName", (Object)"report4.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testRenameToBeanWithBeanLanguage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                FileEndpoint endpoint = new FileEndpoint();
                endpoint.setCamelContext((CamelContext)FileConsumerMoveExpressionTest.this.context);
                endpoint.setFile(new File("target/filelanguage/"));
                endpoint.setAutoCreate(false);
                endpoint.setMove(BeanLanguage.bean((String)"myguidgenerator"));
                endpoint.setExclude(".*bak");
                this.from((Endpoint)endpoint).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bean Language Rules The World"});
        mock.expectedFileExists("target/filelanguage/123");
        this.template.sendBodyAndHeader("file://target/filelanguage/", (Object)"Bean Language Rules The World", "CamelFileName", (Object)"report5.txt");
        this.assertMockEndpointsSatisfied();
    }

    public class MyGuidGenerator {
        public String guid() {
            return "123";
        }
    }
}

