/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeMaxMessagesPerPollTest
extends ContextTestSupport {
    private String fileUrl = "file://target/poll/?maxMessagesPerPoll=2";

    @Override
    protected void setUp() throws Exception {
        FileConsumeMaxMessagesPerPollTest.deleteDirectory("target/poll");
        super.setUp();
    }

    public void testMaxMessagesPerPoll() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        ((ValueBuilder)mock.message(0).exchangeProperty("CamelBatchSize")).isEqualTo((Object)2);
        ((ValueBuilder)mock.message(1).exchangeProperty("CamelBatchSize")).isEqualTo((Object)2);
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Godday World", "CamelFileName", (Object)"godday.txt");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumeMaxMessagesPerPollTest.this.fileUrl).routeId("foo").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

