/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.directvm.AbstractDirectVmTestSupport;
import org.apache.camel.model.RouteDefinition;

public class DirectVmTwoCamelContextTest
extends AbstractDirectVmTestSupport {
    public void testTwoCamelContext() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("name1", (Object)this.context.getName());
        this.getMockEndpoint("mock:result").expectedHeaderReceived("name2", (Object)this.context2.getName());
        String out = (String)this.template2.requestBody("direct:start", (Object)"Hello World", String.class);
        DirectVmTwoCamelContextTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct-vm:foo").transform((Expression)this.constant("Bye World"))).setHeader("name1", (Expression)this.simple("${camelId}"))).log("Running on Camel ${camelId} on thread ${threadName} with message ${body}")).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").setHeader("name2", (Expression)this.simple("${camelId}"))).log("Running on Camel ${camelId} on thread ${threadName} with message ${body}")).to("direct-vm:foo");
            }
        };
    }
}

