/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DirectVmShouldUseSameThreadTest
extends ContextTestSupport {
    private static long id;

    public void testUseSameThread() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct-vm:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                final ThreadLocal local = new ThreadLocal();
                ((RouteDefinition)this.from("direct-vm:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        local.set("Hello");
                        id = Thread.currentThread().getId();
                    }
                })).to("direct-vm:foo");
                ((RouteDefinition)this.from("direct-vm:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"Hello", (String)((String)local.get()));
                        TestCase.assertEquals((long)id, (long)Thread.currentThread().getId());
                    }
                })).to("mock:result");
            }
        };
    }
}

