/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;

public class DefaultParameterMappingStrategyTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public void testExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Exchange"});
        this.template.sendBody("direct:a", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Message"});
        this.template.sendBody("direct:b", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testException() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Exception"});
        this.template.send("direct:c", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello");
                exchange.setException((Throwable)new IllegalArgumentException("Forced by unit test"));
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    public void testTypeConverter() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"TypeConverter"});
        this.template.sendBody("direct:d", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testRegistry() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Registry"});
        this.template.sendBody("direct:e", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testCamelContext() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"CamelContext"});
        this.template.sendBody("direct:f", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").logStackTrace(false).disableRedelivery());
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).bean((Object)"foo", "withException")).to("mock:result");
                ((RouteDefinition)this.from("direct:a").bean((Object)"foo", "withExchange")).to("mock:result");
                ((RouteDefinition)this.from("direct:b").bean((Object)"foo", "withMessage")).to("mock:result");
                this.from("direct:c").to("mock:foo");
                ((RouteDefinition)this.from("direct:d").bean((Object)"foo", "withTypeConverter")).to("mock:result");
                ((RouteDefinition)this.from("direct:e").bean((Object)"foo", "withRegistry")).to("mock:result");
                ((RouteDefinition)this.from("direct:f").bean((Object)"foo", "withCamelContext")).to("mock:result");
            }
        };
    }

    public static class MyFooBean {
        public String withExchange(Exchange exchange) {
            TestCase.assertNotNull((Object)exchange);
            TestCase.assertEquals((String)"Hello", (String)((String)exchange.getIn().getBody(String.class)));
            return "Exchange";
        }

        public String withMessage(Message message) {
            TestCase.assertNotNull((Object)message);
            TestCase.assertEquals((String)"Hello", (String)((String)message.getBody(String.class)));
            return "Message";
        }

        public String withException(Message in, Exception cause) {
            TestCase.assertNotNull((Object)in);
            TestCase.assertNotNull((Object)cause);
            TestCase.assertEquals((String)"Hello", (String)((String)in.getBody(String.class)));
            return "Exception";
        }

        public String withTypeConverter(String body, TypeConverter converter) {
            TestCase.assertNotNull((Object)body);
            TestCase.assertNotNull((Object)converter);
            TestCase.assertEquals((String)"Hello", (String)body);
            TestCase.assertEquals((Object)new Integer(123), (Object)converter.convertTo(Integer.class, (Object)"123"));
            return "TypeConverter";
        }

        public String withRegistry(String body, Registry registry) {
            TestCase.assertNotNull((Object)body);
            TestCase.assertNotNull((Object)registry);
            TestCase.assertNotNull((Object)registry.lookupByName("foo"));
            TestCase.assertEquals((String)"Hello", (String)body);
            return "Registry";
        }

        public String withCamelContext(String body, CamelContext camel) {
            TestCase.assertNotNull((Object)body);
            TestCase.assertNotNull((Object)camel);
            TestCase.assertNotNull((Object)camel.getRegistry().lookupByName("foo"));
            TestCase.assertEquals((String)"Hello", (String)body);
            return "CamelContext";
        }
    }
}

