/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.ExpressionAdapter;

public class CustomParameterMappingStrategyTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        jndi.bind("CamelBeanParameterMappingStrategy", (Object)new MyCustomStrategy());
        return jndi;
    }

    public void testExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"You said: Hello Claus"});
        this.template.sendBody("direct:a", (Object)"Claus");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").bean((Object)"foo")).to("mock:result");
            }
        };
    }

    public static class MyCustomStrategy
    implements ParameterMappingStrategy {
        public Expression getDefaultParameterTypeExpression(Class<?> parameterType) {
            if (String.class.isAssignableFrom(parameterType)) {
                return new ExpressionAdapter(){

                    public Object evaluate(Exchange exchange) {
                        return "Hello " + (String)exchange.getIn().getBody(String.class);
                    }
                };
            }
            return null;
        }
    }

    public static class MyFooBean {
        public String cheese(String body) {
            return "You said: " + body;
        }
    }
}

