/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanParameterValueOverloadedTest
extends ContextTestSupport {
    public void testBeanParameterValueBoolean() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanParameterValueBoolean2() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start2", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:foo?method=bar(*,true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("bean:foo?method=bar(${body},false,true)")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String bar(String body, boolean hello) {
            if (hello) {
                return "Hello " + body;
            }
            return body;
        }

        public String bar(String body, boolean hello, boolean bye) {
            if (hello) {
                return "Hi " + body;
            }
            if (bye) {
                return "Bye " + body;
            }
            return body;
        }
    }
}

