/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.InOnly;
import org.apache.camel.InOut;
import org.apache.camel.Pattern;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.impl.DefaultCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInfoTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BeanInfoTest.class);
    protected CamelContext camelContext = new DefaultCamelContext();

    public void testObjectOperations() throws Exception {
        BeanInfo info = this.createBeanInfo(Object.class);
        List operations = info.getMethods();
        BeanInfoTest.assertEquals((int)1, (int)operations.size());
        BeanInfoTest.assertEquals((String)"toString", (String)((MethodInfo)operations.get(0)).getMethod().getName());
    }

    public void testGetOperations() throws Exception {
        BeanInfo info = this.createBeanInfo(Foo.class);
        List operations = info.getMethods();
        BeanInfoTest.assertEquals((int)3, (int)operations.size());
        BeanInfoTest.assertEquals((String)"inOnlyMethod", (String)((MethodInfo)operations.get(0)).getMethod().getName());
        BeanInfoTest.assertEquals((String)"inOutMethod", (String)((MethodInfo)operations.get(1)).getMethod().getName());
        BeanInfoTest.assertEquals((String)"robustInOnlyMethod", (String)((MethodInfo)operations.get(2)).getMethod().getName());
    }

    public void testMethodPatternUsingMethodAnnotations() throws Exception {
        BeanInfo info = this.createBeanInfo(Foo.class);
        this.assertMethodPattern(info, "inOutMethod", ExchangePattern.InOut);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "robustInOnlyMethod", ExchangePattern.RobustInOnly);
    }

    public void testMethodPatternUsingClassAnnotationsOnInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(MyOneWayInterface.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
    }

    public void testMethodPatternUsingMethodAnnotationsOnInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(MyOneWayInterfaceWithOverloadedMethod.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "robustInOnlyMethod", ExchangePattern.RobustInOnly);
        this.assertMethodPattern(info, "inOutMethod", ExchangePattern.InOut);
    }

    public void testMethodPatternUsingClassAnnotationsButOverloadingOnMethod() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnMethod.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "robustInOnlyMethod", ExchangePattern.RobustInOnly);
    }

    public void testMethodPatternUsingClassAnnotationsButOverloadingOnBaseClassMethod() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnBaseClass.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "robustInOnlyMethod", ExchangePattern.RobustInOnly);
    }

    public void testMethodPatternUsingClassAnnotationsOnClassWithAnnotationsOnInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnMethod.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "robustInOnlyMethod", ExchangePattern.RobustInOnly);
    }

    public void testMethodPatternUsingClassAnnotationsOnBaseInterfaceAndOverloadingMethodOnDerivedInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnInterface.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "robustInOnlyMethod", ExchangePattern.RobustInOnly);
        this.assertMethodPattern(info, "inOutMethod", ExchangePattern.InOut);
    }

    protected BeanInfo createBeanInfo(Class<?> type) {
        BeanInfo info = new BeanInfo(this.camelContext, type);
        return info;
    }

    protected void assertMethodPattern(BeanInfo info, String methodName, ExchangePattern expectedPattern) throws NoSuchMethodException {
        Class type = info.getType();
        Method method = type.getMethod(methodName, new Class[0]);
        BeanInfoTest.assertNotNull((String)("Could not find method: " + methodName), (Object)method);
        MethodInfo methodInfo = info.getMethodInfo(method);
        BeanInfoTest.assertNotNull((String)("Could not find methodInfo for: " + method), (Object)methodInfo);
        ExchangePattern actualPattern = methodInfo.getPattern();
        BeanInfoTest.assertEquals((String)("Pattern for: " + method), (Object)expectedPattern, (Object)actualPattern);
        LOG.info("Method: " + method + " has pattern: " + actualPattern);
    }

    public static class OverloadOnInterface
    implements MyOneWayInterfaceWithOverloadedMethod {
        @Override
        public void inOnlyMethod() {
        }

        @Override
        public void robustInOnlyMethod() {
        }

        @Override
        public Object inOutMethod() {
            return null;
        }
    }

    public static class OverloadOnBaseClass
    extends OverloadOnMethod {
        @Override
        public void robustInOnlyMethod() {
        }
    }

    public static class OverloadOnMethod
    implements MyOneWayInterface {
        @Override
        public void inOnlyMethod() {
        }

        @Pattern(value=ExchangePattern.RobustInOnly)
        public void robustInOnlyMethod() {
        }
    }

    @InOnly
    public static interface MyOneWayInterfaceWithOverloadedMethod {
        public void inOnlyMethod();

        @Pattern(value=ExchangePattern.RobustInOnly)
        public void robustInOnlyMethod();

        @InOut
        public Object inOutMethod();
    }

    @InOnly
    public static interface MyOneWayInterface {
        public void inOnlyMethod();
    }

    public static interface Foo {
        public void inOutMethod();

        @Pattern(value=ExchangePattern.InOnly)
        public void inOnlyMethod();

        @Pattern(value=ExchangePattern.RobustInOnly)
        public void robustInOnlyMethod();
    }
}

