/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class BeanInfoSelectMethodTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public void testOrder() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Order"});
        this.template.sendBody("direct:a", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailure() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Failure"});
        this.template.send("direct:b", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello");
                exchange.setException((Throwable)new IllegalArgumentException("Forced by unit test"));
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").logStackTrace(false).maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).bean((Object)"foo", "handleFailure")).to("mock:result");
                ((RouteDefinition)this.from("direct:a").bean((Object)"foo")).to("mock:result");
                this.from("direct:b").to("mock:foo");
            }
        };
    }

    public static class MyFooBean {
        public String handleException(Exception e) {
            TestCase.fail((String)"Should not call this method as it is not intended for Camel");
            return "Exception";
        }

        public String handleFailure(@Body String order, @ExchangeException IllegalArgumentException e) {
            return "Failure";
        }

        public String handleOrder(@Body String order) {
            return "Order";
        }
    }
}

