/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class PredicateBinaryCoerceRouteTest
extends ContextTestSupport {
    public void testNoHeader() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(0);
        this.getMockEndpoint("mock:456").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsNumber123() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(1);
        this.getMockEndpoint("mock:456").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsNumber456() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(0);
        this.getMockEndpoint("mock:456").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)456);
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsNumber999() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(0);
        this.getMockEndpoint("mock:456").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)999);
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsString123() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(1);
        this.getMockEndpoint("mock:456").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsString456() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(0);
        this.getMockEndpoint("mock:456").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"456");
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsString999() throws Exception {
        this.getMockEndpoint("mock:123").expectedMessageCount(0);
        this.getMockEndpoint("mock:456").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"999");
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsEnum() throws Exception {
        this.getMockEndpoint("mock:enum").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)WaitForTaskToComplete.Always);
        this.assertMockEndpointsSatisfied();
    }

    public void testHeaderAsEnumString() throws Exception {
        this.getMockEndpoint("mock:enum").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"Always");
        this.assertMockEndpointsSatisfied();
    }

    public void testOtherMax() throws Exception {
        this.getMockEndpoint("mock:max").expectedMessageCount(1);
        this.getMockEndpoint("mock:min").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"250");
        this.assertMockEndpointsSatisfied();
    }

    public void testOtherMin() throws Exception {
        this.getMockEndpoint("mock:max").expectedMessageCount(0);
        this.getMockEndpoint("mock:min").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"200");
        this.assertMockEndpointsSatisfied();
    }

    public void testOtherAlways() throws Exception {
        this.getMockEndpoint("mock:max").expectedMessageCount(0);
        this.getMockEndpoint("mock:min").expectedMessageCount(0);
        this.getMockEndpoint("mock:enum").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "enum", (Object)"Always");
        this.assertMockEndpointsSatisfied();
    }

    public void testOtherNewer() throws Exception {
        this.getMockEndpoint("mock:max").expectedMessageCount(0);
        this.getMockEndpoint("mock:min").expectedMessageCount(0);
        this.getMockEndpoint("mock:enum").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "enum", (Object)"Never");
        this.assertMockEndpointsSatisfied();
    }

    public void testOtherIfReplyExpected() throws Exception {
        this.getMockEndpoint("mock:max").expectedMessageCount(0);
        this.getMockEndpoint("mock:min").expectedMessageCount(0);
        this.getMockEndpoint("mock:enum").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "enum", (Object)WaitForTaskToComplete.IfReplyExpected);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.header("foo").isEqualTo((Object)"123")).to("mock:123")).when(this.header("foo").isEqualTo((Object)456)).to("mock:456")).when(this.header("foo").isEqualTo((Object)WaitForTaskToComplete.Always)).to("mock:enum")).otherwise().to("mock:other");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:foo").choice().when(this.header("enum").isGreaterThanOrEqualTo((Object)WaitForTaskToComplete.IfReplyExpected)).to("mock:enum")).when(this.header("foo").isGreaterThan((Object)"200")).to("mock:max")).when(this.header("foo").isLessThanOrEqualTo((Object)200)).to("mock:min")).otherwise().to("mock:other");
            }
        };
    }
}

