/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.sparkrest.DefaultSparkBinding;
import org.apache.camel.component.sparkrest.SparkBinding;
import org.apache.camel.component.sparkrest.SparkConfiguration;
import org.apache.camel.component.sparkrest.SparkEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import spark.SparkBase;

public class SparkComponent
extends UriEndpointComponent
implements RestConsumerFactory {
    private final Pattern pattern = Pattern.compile("\\{(.*?)\\}");
    private int port = 4567;
    private String ipAddress;
    private SparkConfiguration sparkConfiguration = new SparkConfiguration();
    private SparkBinding sparkBinding = new DefaultSparkBinding();

    public SparkComponent() {
        super(SparkEndpoint.class);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public SparkConfiguration getSparkConfiguration() {
        return this.sparkConfiguration;
    }

    public void setSparkConfiguration(SparkConfiguration sparkConfiguration) {
        this.sparkConfiguration = sparkConfiguration;
    }

    public SparkBinding getSparkBinding() {
        return this.sparkBinding;
    }

    public void setSparkBinding(SparkBinding sparkBinding) {
        this.sparkBinding = sparkBinding;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SparkEndpoint answer = new SparkEndpoint(uri, (Component)this);
        answer.setSparkConfiguration(this.getSparkConfiguration());
        answer.setSparkBinding(this.getSparkBinding());
        this.setProperties((Object)answer, parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be spark-rest:verb:path");
        }
        String verb = ObjectHelper.before((String)remaining, (String)":");
        String path = ObjectHelper.after((String)remaining, (String)":");
        answer.setVerb(verb);
        answer.setPath(path);
        return answer;
    }

    protected void doStart() throws Exception {
        RestConfiguration config;
        super.doStart();
        if (this.getPort() != 4567) {
            SparkBase.setPort((int)this.getPort());
        } else {
            config = this.getCamelContext().getRestConfiguration("spark-rest", true);
            int port = config.getPort();
            if (port > 0) {
                SparkBase.setPort((int)port);
            }
        }
        if (this.getIpAddress() != null) {
            SparkBase.setIpAddress((String)this.getIpAddress());
        }
        if ((config = this.getCamelContext().getRestConfiguration("spark-rest", true)).getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties(this.sparkConfiguration, config.getComponentProperties());
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        SparkBase.stop();
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String contextPath;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("spark-rest", true);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (consumes != null) {
            map.put("accept", consumes);
        }
        if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (ObjectHelper.isNotEmpty((Object)path)) {
            Matcher matcher = this.pattern.matcher(path);
            path = matcher.replaceAll(":$1");
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        String uri = String.format("spark-rest:%s:%s", verb, path);
        String query = URISupport.createQueryString(map);
        String url = uri;
        if (!query.isEmpty()) {
            url = url + "?" + query;
        }
        SparkEndpoint endpoint = (SparkEndpoint)camelContext.getEndpoint(url, SparkEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }
}

