/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift;

import com.openshift.client.IApplication;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.openshift.OpenShiftConsumer;
import org.apache.camel.component.openshift.OpenShiftOperation;
import org.apache.camel.component.openshift.OpenShiftProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="openshift", title="OpenShift", syntax="openshift:clientId", consumerClass=OpenShiftConsumer.class, label="cloud")
public class OpenShiftEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required="true")
    private String clientId;
    @UriPath
    @Metadata(required="true")
    private String username;
    @UriPath
    @Metadata(required="true")
    private String password;
    @UriParam
    private String domain;
    @UriParam
    private String server;
    @UriParam(label="producer", enums="list,start,stop,restart,state,getStandaloneCartridge,getEmbeddedCartridges,addEmbeddedCartridge,removeEmbeddedCartridge,scaleUp,scaleDown,getGitUrl,getDeploymentType,setDeploymentType,getAllEnvironmentVariables,addEnvironmentVariable,addMultipleEnvironmentVariables,updateEnvironmentVariable,getEnvironmentVariableValue,removeEnvironmentVariable,getGearProfile,addAlias,removeAlias,getAliases")
    private String operation;
    @UriParam(label="producer")
    private String application;
    @UriParam(label="producer", enums="pojo,json")
    private String mode;

    public OpenShiftEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notEmpty((String)this.clientId, (String)"clientId", (Object)((Object)this));
        ObjectHelper.notEmpty((String)this.username, (String)"username", (Object)((Object)this));
        ObjectHelper.notEmpty((String)this.password, (String)"password", (Object)((Object)this));
        return new OpenShiftProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notEmpty((String)this.clientId, (String)"clientId", (Object)((Object)this));
        ObjectHelper.notEmpty((String)this.username, (String)"username", (Object)((Object)this));
        ObjectHelper.notEmpty((String)this.password, (String)"password", (Object)((Object)this));
        OpenShiftConsumer consumer = new OpenShiftConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(IApplication application) {
        Exchange exchange = super.createExchange();
        exchange.getIn().setBody((Object)application);
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setOperation(OpenShiftOperation operation) {
        this.operation = operation.name();
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

