/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cmis.CMISComponent;
import org.apache.camel.component.cmis.CMISConsumer;
import org.apache.camel.component.cmis.CMISProducer;
import org.apache.camel.component.cmis.CMISQueryProducer;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="cmis", title="CMIS", syntax="cmis:url", consumerClass=CMISConsumer.class, label="cms,database")
public class CMISEndpoint
extends DefaultEndpoint {
    @UriParam
    private CMISSessionFacade sessionFacade;
    @UriParam(label="producer")
    private boolean queryMode;

    public CMISEndpoint() {
    }

    public CMISEndpoint(String uri, CMISComponent component) {
        super(uri, (Component)component);
    }

    public CMISEndpoint(String uri, CMISComponent cmisComponent, CMISSessionFacade sessionFacade) {
        this(uri, cmisComponent);
        this.sessionFacade = sessionFacade;
    }

    public Producer createProducer() throws Exception {
        if (this.queryMode) {
            return new CMISQueryProducer(this, this.sessionFacade);
        }
        return new CMISProducer(this, this.sessionFacade);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CMISConsumer answer = new CMISConsumer(this, processor, this.sessionFacade);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(boolean queryMode) {
        this.queryMode = queryMode;
    }
}

