/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import com.google.api.services.calendar.Calendar;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.calendar.BatchGoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.GoogleCalendarConfiguration;
import org.apache.camel.component.google.calendar.GoogleCalendarEndpoint;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiCollection;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiName;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class GoogleCalendarComponent
extends AbstractApiComponent<GoogleCalendarApiName, GoogleCalendarConfiguration, GoogleCalendarApiCollection> {
    private Calendar client;
    private GoogleCalendarClientFactory clientFactory;

    public GoogleCalendarComponent() {
        super(GoogleCalendarEndpoint.class, GoogleCalendarApiName.class, (ApiCollection)GoogleCalendarApiCollection.getCollection());
    }

    public GoogleCalendarComponent(CamelContext context) {
        super(context, GoogleCalendarEndpoint.class, GoogleCalendarApiName.class, (ApiCollection)GoogleCalendarApiCollection.getCollection());
    }

    protected GoogleCalendarApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return GoogleCalendarApiName.fromValue(apiNameStr);
    }

    public Calendar getClient() {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(((GoogleCalendarConfiguration)this.configuration).getClientId(), ((GoogleCalendarConfiguration)this.configuration).getClientSecret(), ((GoogleCalendarConfiguration)this.configuration).getScopes(), ((GoogleCalendarConfiguration)this.configuration).getApplicationName(), ((GoogleCalendarConfiguration)this.configuration).getRefreshToken(), ((GoogleCalendarConfiguration)this.configuration).getAccessToken(), ((GoogleCalendarConfiguration)this.configuration).getEmailAddress(), ((GoogleCalendarConfiguration)this.configuration).getP12FileName(), ((GoogleCalendarConfiguration)this.configuration).getUser());
        }
        return this.client;
    }

    public GoogleCalendarClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleCalendarClientFactory();
        }
        return this.clientFactory;
    }

    public GoogleCalendarConfiguration getConfiguration() {
        return (GoogleCalendarConfiguration)super.getConfiguration();
    }

    public void setConfiguration(GoogleCalendarConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public void setClientFactory(GoogleCalendarClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleCalendarApiName apiName, GoogleCalendarConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleCalendarEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

