/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.schematron.SchematronComponent;
import org.apache.camel.component.schematron.SchematronProducer;
import org.apache.camel.component.schematron.exception.SchematronConfigException;
import org.apache.camel.component.schematron.processor.ClassPathURIResolver;
import org.apache.camel.component.schematron.processor.TemplatesFactory;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ResourceHelper;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="schematron", title="Schematron", syntax="schematron:path", producerOnly=true, label="validation")
public class SchematronEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SchematronEndpoint.class);
    private TransformerFactory transformerFactory;
    @UriPath
    @Metadata(required="true")
    private String path;
    @UriParam
    private boolean abort;
    @UriParam
    private Templates rules;

    public SchematronEndpoint() {
    }

    public SchematronEndpoint(String uri, String path, SchematronComponent component) {
        super(uri, (Component)component);
        this.path = path;
    }

    public SchematronEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        return new SchematronProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public Templates getRules() {
        return this.rules;
    }

    public void setRules(Templates rules) {
        this.rules = rules;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.transformerFactory == null) {
            this.createTransformerFactory();
        }
        if (this.rules == null) {
            try {
                LOG.debug("Reading schematron rules from class path {}", (Object)this.path);
                InputStream schRules = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.path);
                this.rules = TemplatesFactory.newInstance().getTemplates(schRules, this.transformerFactory);
            }
            catch (Exception classPathException) {
                LOG.debug("Error loading schematron rules from class path, attempting file system {}", (Object)this.path);
                try {
                    FileInputStream schRules = FileUtils.openInputStream((File)new File(this.path));
                    this.rules = TemplatesFactory.newInstance().getTemplates(schRules, this.transformerFactory);
                }
                catch (FileNotFoundException e) {
                    LOG.debug("Schematron rules not found in the file system {}", (Object)this.path);
                    throw classPathException;
                }
            }
            if (this.rules == null) {
                LOG.error("Failed to load schematron rules {}", (Object)this.path);
                throw new SchematronConfigException("Failed to load schematron rules: " + this.path);
            }
        }
    }

    private void createTransformerFactory() throws ClassNotFoundException {
        Class factoryClass = this.getCamelContext().getClassResolver().resolveMandatoryClass("net.sf.saxon.TransformerFactoryImpl", TransformerFactory.class, SchematronComponent.class.getClassLoader());
        LOG.debug("Using TransformerFactoryClass {}", (Object)factoryClass);
        this.transformerFactory = (TransformerFactory)this.getCamelContext().getInjector().newInstance(factoryClass);
        this.transformerFactory.setURIResolver(new ClassPathURIResolver("iso-schematron-xslt2"));
        this.transformerFactory.setAttribute("http://saxon.sf.net/feature/linenumbering", true);
    }
}

