/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx.support;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.rx.support.ProcessorToObserver;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.Subscription;
import rx.functions.Func1;

public class EndpointSubscription<T>
implements Subscription {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointSubscription.class);
    private final Endpoint endpoint;
    private final Observer<? super T> observer;
    private Consumer consumer;
    private final AtomicBoolean unsubscribed = new AtomicBoolean(false);

    public EndpointSubscription(Endpoint endpoint, Observer<? super T> observer, Func1<Exchange, T> func) {
        this.endpoint = endpoint;
        this.observer = observer;
        ProcessorToObserver<? super T> processor = new ProcessorToObserver<T>(func, observer);
        CamelInternalProcessor internal = new CamelInternalProcessor(processor);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
        try {
            this.consumer = endpoint.createConsumer((Processor)internal);
            ServiceHelper.startService((Service)this.consumer);
        }
        catch (Exception e) {
            observer.onError((Throwable)e);
        }
    }

    public String toString() {
        return "EndpointSubscription[" + this.endpoint + " observer: " + this.observer + "]";
    }

    public void unsubscribe() {
        if (this.unsubscribed.compareAndSet(false, true) && this.consumer != null) {
            try {
                ServiceHelper.stopServices((Object[])new Object[]{this.consumer});
            }
            catch (Exception e) {
                LOG.warn("Error stopping consumer: " + this.consumer + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
        }
    }

    public boolean isUnsubscribed() {
        return this.unsubscribed.get();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Observer<? super T> getObserver() {
        return this.observer;
    }
}

