/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.gora.GoraConfiguration;
import org.apache.camel.component.gora.utils.GoraUtils;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoraConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GoraConsumer.class);
    private final DataStore<Object, Persistent> dataStore;
    private final GoraConfiguration configuration;
    private Query query;
    private ExecutorService executor;
    private boolean firstRun;

    public GoraConsumer(Endpoint endpoint, Processor processor, GoraConfiguration configuration, DataStore<Object, Persistent> dataStore) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        super(endpoint, processor);
        this.configuration = configuration;
        this.dataStore = dataStore;
        this.query = GoraUtils.constractQueryFromConfiguration(this.dataStore, this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        if (this.firstRun) {
            this.query.setStartTime(System.currentTimeMillis());
        } else {
            this.query.setStartTime(System.currentTimeMillis() - this.getDelay());
        }
        Result result = this.query.execute();
        LOG.trace("Processing exchange [{}]...", (Object)exchange);
        try {
            this.getProcessor().process(exchange);
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
        return Long.valueOf(result.getOffset()).intValue();
    }
}

