/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.hadoop.conf.Configuration;

@UriParams
public class GoraConfiguration {
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam
    private String keyClass;
    @UriParam
    private Configuration hadoopConfiguration = new Configuration();
    @UriParam
    private String valueClass;
    @UriParam
    private String dataStoreClass;
    @UriParam
    private long startTime;
    @UriParam
    private long endTime;
    @UriParam
    private long timeRangeFrom;
    @UriParam
    private long timeRangeTo;
    @UriParam
    private long limit;
    @UriParam
    private long timestamp;
    @UriParam
    private Object startKey;
    @UriParam
    private Object endKey;
    @UriParam
    private Object keyRangeFrom;
    @UriParam
    private Object keyRangeTo;
    @UriParam
    private Strings fields;
    @UriParam(defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(defaultValue="true")
    private boolean flushOnEveryOperation = true;

    public String getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(String keyClass) {
        if (Strings.isNullOrEmpty((String)keyClass)) {
            throw new IllegalArgumentException("Key class could not be null or empty!");
        }
        this.keyClass = keyClass;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(String valueClass) {
        if (Strings.isNullOrEmpty((String)valueClass)) {
            throw new IllegalArgumentException("Value class  could not be null or empty!");
        }
        this.valueClass = valueClass;
    }

    public String getDataStoreClass() {
        return this.dataStoreClass;
    }

    public void setDataStoreClass(String dataStoreClass) {
        if (Strings.isNullOrEmpty((String)dataStoreClass)) {
            throw new IllegalArgumentException("DataStore class could not be null or empty!");
        }
        this.dataStoreClass = dataStoreClass;
    }

    public Configuration getHadoopConfiguration() {
        return this.hadoopConfiguration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getTimeRangeFrom() {
        return this.timeRangeFrom;
    }

    public void setTimeRangeFrom(long timeRangeFrom) {
        this.timeRangeFrom = timeRangeFrom;
    }

    public long getTimeRangeTo() {
        return this.timeRangeTo;
    }

    public void setTimeRangeTo(long timeRangeTo) {
        this.timeRangeTo = timeRangeTo;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Object getStartKey() {
        return this.startKey;
    }

    public void setStartKey(Object startKey) {
        this.startKey = startKey;
    }

    public Object getEndKey() {
        return this.endKey;
    }

    public void setEndKey(Object endKey) {
        this.endKey = endKey;
    }

    public Object getKeyRangeFrom() {
        return this.keyRangeFrom;
    }

    public void setKeyRangeFrom(Object keyRangeFrom) {
        this.keyRangeFrom = keyRangeFrom;
    }

    public Object getKeyRangeTo() {
        return this.keyRangeTo;
    }

    public void setKeyRangeTo(Object keyRangeTo) {
        this.keyRangeTo = keyRangeTo;
    }

    public Strings getFields() {
        return this.fields;
    }

    public void setFields(Strings fields) {
        this.fields = fields;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public boolean isFlushOnEveryOperation() {
        return this.flushOnEveryOperation;
    }

    public void setFlushOnEveryOperation(boolean flushOnEveryOperation) {
        this.flushOnEveryOperation = flushOnEveryOperation;
    }

    public void setHadoopConfiguration(Configuration hadoopConfiguration) {
        Preconditions.checkNotNull((Object)hadoopConfiguration, (Object)"Hadoop Configuration could not be null!");
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

