/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SqsProducer.class);
    private transient String sqsProducerToString;

    public SqsProducer(SqsEndpoint endpoint) throws NoFactoryAvailableException {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getIn().getBody(String.class);
        SendMessageRequest request = new SendMessageRequest(this.getQueueUrl(), body);
        request.setMessageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
        this.addDelay(request, exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        SendMessageResult result = this.getClient().sendMessage(request);
        LOG.trace("Received result [{}]", (Object)result);
        Message message = this.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSqsMessageId", (Object)result.getMessageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)result.getMD5OfMessageBody());
    }

    private void addDelay(SendMessageRequest request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (headerValue == null) {
            LOG.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            LOG.trace("Using the header delay");
            delayValue = headerValue;
        }
        LOG.trace("found delay: " + delayValue);
        request.setDelaySeconds(delayValue == null ? Integer.valueOf(0) : delayValue);
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    protected AmazonSQS getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    public SqsEndpoint getEndpoint() {
        return (SqsEndpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.sqsProducerToString == null) {
            this.sqsProducerToString = "SqsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sqsProducerToString;
    }

    private Map<String, MessageAttributeValue> translateAttributes(Map<String, Object> headers, Exchange exchange) {
        HashMap<String, MessageAttributeValue> result = new HashMap<String, MessageAttributeValue>();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            MessageAttributeValue mav;
            if (headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                mav = new MessageAttributeValue();
                mav.setDataType("String");
                mav.withStringValue((String)value);
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof ByteBuffer) {
                mav = new MessageAttributeValue();
                mav.setDataType("Binary");
                mav.withBinaryValue((ByteBuffer)value);
                result.put(entry.getKey(), mav);
                continue;
            }
            LOG.warn("Cannot put the message header key={}, value={} into Sqs MessageAttribute", (Object)entry.getKey(), entry.getValue());
        }
        return result;
    }
}

