/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SnsProducer.class);
    private transient String snsProducerToString;

    public SnsProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        PublishRequest request = new PublishRequest();
        request.setTopicArn(this.getConfiguration().getTopicArn());
        request.setSubject(this.determineSubject(exchange));
        request.setMessageStructure(this.determineMessageStructure(exchange));
        request.setMessage((String)exchange.getIn().getBody(String.class));
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PublishResult result = this.getEndpoint().getSNSClient().publish(request);
        LOG.trace("Received result [{}]", (Object)result);
        Message message = this.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSnsMessageId", (Object)result.getMessageId());
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSnsSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    private String determineMessageStructure(Exchange exchange) {
        String structure = (String)exchange.getIn().getHeader("CamelAwsSnsMessageStructure", String.class);
        if (structure == null) {
            structure = this.getConfiguration().getMessageStructure();
        }
        return structure;
    }

    protected SnsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.snsProducerToString == null) {
            this.snsProducerToString = "SnsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.snsProducerToString;
    }

    public SnsEndpoint getEndpoint() {
        return (SnsEndpoint)super.getEndpoint();
    }
}

