/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class QueryCommand
extends AbstractDdbCommand {
    public QueryCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        QueryResult result = this.ddbClient.query(new QueryRequest().withTableName(this.determineTableName()).withAttributesToGet(this.determineAttributeNames()).withConsistentRead(this.determineConsistentRead()).withExclusiveStartKey(this.determineStartKey()).withKeyConditions(this.determineKeyConditions()).withExclusiveStartKey(this.determineStartKey()).withLimit(this.determineLimit()).withScanIndexForward(this.determineScanIndexForward()));
        this.addToResult("CamelAwsDdbItems", result.getItems());
        this.addToResult("CamelAwsDdbLastEvaluatedKey", result.getLastEvaluatedKey());
        this.addToResult("CamelAwsDdbConsumedCapacity", result.getConsumedCapacity());
        this.addToResult("CamelAwsDdbCount", result.getCount());
    }

    private Map<String, AttributeValue> determineStartKey() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbStartKey", Map.class);
    }

    private Boolean determineScanIndexForward() {
        return (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbScanIndexForward", Boolean.class);
    }

    private Map determineKeyConditions() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbKeyConditions", Map.class);
    }

    private Integer determineLimit() {
        return (Integer)this.exchange.getIn().getHeader("CamelAwsDdbLimit", Integer.class);
    }
}

