/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class BatchGetItemsCommand
extends AbstractDdbCommand {
    public BatchGetItemsCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        BatchGetItemResult result = this.ddbClient.batchGetItem(new BatchGetItemRequest().withRequestItems(this.determineBatchItems()));
        this.addToResult("CamelAwsDdbBatchResponse", result.getResponses());
        this.addToResult("CamelAwsDdbUnprocessedKeys", result.getUnprocessedKeys());
    }

    private Map<String, KeysAndAttributes> determineBatchItems() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbBatchItems", Map.class);
    }
}

