/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.producer.Twitter4JProducer;
import org.apache.camel.util.ObjectHelper;

public class DirectMessageProducer
extends Twitter4JProducer {
    public DirectMessageProducer(TwitterEndpoint te) {
        super(te);
    }

    public void process(Exchange exchange) throws Exception {
        String toUsername = this.te.getProperties().getUser();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelTwitterUser", String.class))) {
            toUsername = (String)exchange.getIn().getHeader("CamelTwitterUser", String.class);
        }
        String text = (String)exchange.getIn().getBody(String.class);
        if (toUsername.isEmpty()) {
            throw new CamelExchangeException("Username not configured on TwitterEndpoint", exchange);
        }
        this.log.debug("Sending to: {} message: {}", (Object)toUsername, (Object)text);
        this.te.getProperties().getTwitter().sendDirectMessage(toUsername, text);
    }
}

