/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.batch;

import javax.jms.Session;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sjms.SjmsHeaderFilterStrategy;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.batch.SjmsBatchComponent;
import org.apache.camel.component.sjms.batch.SjmsBatchConsumer;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.DestinationNameParser;
import org.apache.camel.component.sjms.jms.JmsBinding;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="sjms-batch", title="Simple JMS Batch Component", syntax="sjms-batch:destinationName", consumerClass=SjmsBatchComponent.class, label="messaging", consumerOnly=true)
public class SjmsBatchEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    public static final int DEFAULT_COMPLETION_SIZE = 200;
    public static final int DEFAULT_COMPLETION_TIMEOUT = 500;
    public static final String PROPERTY_BATCH_SIZE = "CamelSjmsBatchSize";
    private JmsBinding binding;
    @UriPath
    @Metadata(required="true")
    private String destinationName;
    @UriParam(defaultValue="1")
    private int consumerCount = 1;
    @UriParam(defaultValue="200")
    private int completionSize = 200;
    @UriParam(defaultValue="500")
    private int completionTimeout = 500;
    @UriParam(defaultValue="1000")
    private int pollDuration = 1000;
    @UriParam
    @Metadata(required="true")
    private AggregationStrategy aggregationStrategy;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam
    private boolean includeAllJMSXProperties;
    @UriParam(defaultValue="true")
    private boolean allowNullBody = true;
    @UriParam(defaultValue="true")
    private boolean mapJmsMessage = true;
    @UriParam
    private MessageCreatedStrategy messageCreatedStrategy;
    @UriParam
    private JmsKeyFormatStrategy jmsKeyFormatStrategy;

    public SjmsBatchEndpoint() {
    }

    public SjmsBatchEndpoint(String endpointUri, Component component, String remaining) {
        super(endpointUri, component);
        DestinationNameParser parser = new DestinationNameParser();
        if (parser.isTopic(remaining)) {
            throw new IllegalArgumentException("Only batch consumption from queues is supported. For topics you should use a regular JMS consumer with an aggregator.");
        }
        this.destinationName = parser.getShortName(remaining);
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Cannot produce though a " + SjmsBatchEndpoint.class.getName());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new SjmsBatchConsumer(this, processor);
    }

    public Exchange createExchange(javax.jms.Message message, Session session) {
        Exchange exchange = this.createExchange(this.getExchangePattern());
        exchange.setIn((Message)new SjmsMessage(message, session, this.getBinding()));
        return exchange;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createBinding();
        }
        return this.binding;
    }

    protected JmsBinding createBinding() {
        return new JmsBinding(this.isMapJmsMessage(), this.isAllowNullBody(), this.getHeaderFilterStrategy(), this.getJmsKeyFormatStrategy(), this.getMessageCreatedStrategy());
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(int consumerCount) {
        this.consumerCount = consumerCount;
    }

    public int getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(int completionSize) {
        this.completionSize = completionSize;
    }

    public int getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(int completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public int getPollDuration() {
        return this.pollDuration;
    }

    public void setPollDuration(int pollDuration) {
        this.pollDuration = pollDuration;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public boolean isMapJmsMessage() {
        return this.mapJmsMessage;
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.mapJmsMessage = mapJmsMessage;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        if (this.jmsKeyFormatStrategy == null) {
            this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
        }
        return this.jmsKeyFormatStrategy;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SjmsHeaderFilterStrategy(this.isIncludeAllJMSXProperties());
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public boolean isIncludeAllJMSXProperties() {
        return this.includeAllJMSXProperties;
    }

    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.includeAllJMSXProperties = includeAllJMSXProperties;
    }
}

