/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.batch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.sjms.batch.SessionCompletion;
import org.apache.camel.component.sjms.batch.SjmsBatchComponent;
import org.apache.camel.component.sjms.batch.SjmsBatchEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjmsBatchConsumer
extends DefaultConsumer {
    private static final boolean TRANSACTED = true;
    private static final Logger LOG = LoggerFactory.getLogger(SjmsBatchConsumer.class);
    private static final AtomicInteger BATCH_COUNT = new AtomicInteger();
    private static final AtomicLong MESSAGE_RECEIVED = new AtomicLong();
    private static final AtomicLong MESSAGE_PROCESSED = new AtomicLong();
    private final SjmsBatchEndpoint sjmsBatchEndpoint;
    private final AggregationStrategy aggregationStrategy;
    private final int completionSize;
    private final int completionTimeout;
    private final int consumerCount;
    private final int pollDuration;
    private final ConnectionFactory connectionFactory;
    private final String destinationName;
    private final Processor processor;
    private ExecutorService jmsConsumerExecutors;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicReference<CountDownLatch> consumersShutdownLatchRef = new AtomicReference();
    private Connection connection;

    public SjmsBatchConsumer(SjmsBatchEndpoint sjmsBatchEndpoint, Processor processor) {
        super((Endpoint)sjmsBatchEndpoint, processor);
        this.sjmsBatchEndpoint = (SjmsBatchEndpoint)((Object)ObjectHelper.notNull((Object)((Object)sjmsBatchEndpoint), (String)"batchJmsEndpoint"));
        this.processor = (Processor)ObjectHelper.notNull((Object)processor, (String)"processor");
        this.destinationName = ObjectHelper.notEmpty((String)sjmsBatchEndpoint.getDestinationName(), (String)"destinationName");
        this.completionSize = sjmsBatchEndpoint.getCompletionSize();
        this.completionTimeout = sjmsBatchEndpoint.getCompletionTimeout();
        this.pollDuration = sjmsBatchEndpoint.getPollDuration();
        if (this.pollDuration < 0) {
            throw new IllegalArgumentException("pollDuration must be 0 or greater");
        }
        this.aggregationStrategy = (AggregationStrategy)ObjectHelper.notNull((Object)sjmsBatchEndpoint.getAggregationStrategy(), (String)"aggregationStrategy");
        this.consumerCount = sjmsBatchEndpoint.getConsumerCount();
        if (this.consumerCount <= 0) {
            throw new IllegalArgumentException("consumerCount must be greater than 0");
        }
        SjmsBatchComponent sjmsBatchComponent = (SjmsBatchComponent)sjmsBatchEndpoint.getComponent();
        this.connectionFactory = (ConnectionFactory)ObjectHelper.notNull((Object)sjmsBatchComponent.getConnectionFactory(), (String)"jmsBatchComponent.connectionFactory");
    }

    public SjmsBatchEndpoint getEndpoint() {
        return this.sjmsBatchEndpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            this.connection = this.connectionFactory.createConnection();
            this.connection.start();
        }
        catch (JMSException ex) {
            LOG.error("Exception caught closing connection: {}", (Object)this.getStackTrace((Exception)((Object)ex)));
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting " + this.consumerCount + " consumer(s) for " + this.destinationName + ":" + this.completionSize);
        }
        this.consumersShutdownLatchRef.set(new CountDownLatch(this.consumerCount));
        this.jmsConsumerExecutors = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "SjmsBatchConsumer", this.consumerCount);
        for (int i = 0; i < this.consumerCount; ++i) {
            this.jmsConsumerExecutors.execute(new BatchConsumptionLoop());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.running.set(false);
        CountDownLatch consumersShutdownLatch = this.consumersShutdownLatchRef.get();
        if (consumersShutdownLatch != null) {
            LOG.info("Stop signalled, waiting on consumers to shut down");
            if (consumersShutdownLatch.await(60L, TimeUnit.SECONDS)) {
                LOG.warn("Timeout waiting on consumer threads to signal completion - shutting down");
            } else {
                LOG.info("All consumers have shut down");
            }
        } else {
            LOG.info("Stop signalled while there are no consumers yet, so no need to wait for consumers");
        }
        try {
            LOG.debug("Shutting down JMS connection");
            this.connection.close();
        }
        catch (JMSException jex) {
            LOG.error("Exception caught closing connection: {}", (Object)this.getStackTrace((Exception)((Object)jex)));
        }
        this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown(this.jmsConsumerExecutors);
    }

    private String getStackTrace(Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private class BatchConsumptionLoop
    implements Runnable {
        private BatchConsumptionLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Session session = SjmsBatchConsumer.this.connection.createSession(true, 2);
                try {
                    Queue queue = session.createQueue(SjmsBatchConsumer.this.destinationName);
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    try {
                        this.consumeBatchesOnLoop(session, consumer);
                    }
                    finally {
                        try {
                            consumer.close();
                        }
                        catch (JMSException ex2) {
                            SjmsBatchConsumer.this.log.error("Exception caught closing consumer: {}", (Object)ex2.getMessage());
                        }
                    }
                }
                finally {
                    try {
                        session.close();
                    }
                    catch (JMSException ex1) {
                        SjmsBatchConsumer.this.log.error("Exception caught closing session: {}", (Object)ex1.getMessage());
                    }
                }
            }
            catch (JMSException ex) {
                LOG.error("Exception caught consuming from {}: {}", (Object)SjmsBatchConsumer.this.destinationName, (Object)SjmsBatchConsumer.this.getStackTrace((Exception)((Object)ex)));
            }
            finally {
                CountDownLatch consumersShutdownLatch = (CountDownLatch)SjmsBatchConsumer.this.consumersShutdownLatchRef.get();
                consumersShutdownLatch.countDown();
            }
        }

        private void consumeBatchesOnLoop(Session session, MessageConsumer consumer) throws JMSException {
            boolean usingTimeout;
            boolean bl = usingTimeout = SjmsBatchConsumer.this.completionTimeout > 0;
            block0: while (SjmsBatchConsumer.this.running.get()) {
                int messageCount = 0;
                long timeElapsed = 0L;
                long startTime = 0L;
                Exchange aggregatedExchange = null;
                while (SjmsBatchConsumer.this.completionSize <= 0 || messageCount < SjmsBatchConsumer.this.completionSize) {
                    long waitTime = usingTimeout && timeElapsed > 0L ? this.getReceiveWaitTime(timeElapsed) : (long)SjmsBatchConsumer.this.pollDuration;
                    Message message = consumer.receive(waitTime);
                    if (SjmsBatchConsumer.this.running.get()) {
                        long currentTime;
                        if (message == null) {
                            LOG.trace("No message received");
                        } else {
                            if (usingTimeout && messageCount == 0) {
                                startTime = new Date().getTime();
                            }
                            LOG.debug("Message received: {}", (Object)(++messageCount));
                            if (message instanceof ObjectMessage || message instanceof TextMessage) {
                                Exchange exchange = SjmsBatchConsumer.this.getEndpoint().createExchange(message, session);
                                aggregatedExchange = SjmsBatchConsumer.this.aggregationStrategy.aggregate(aggregatedExchange, exchange);
                                aggregatedExchange.setProperty("CamelSjmsBatchSize", (Object)messageCount);
                            } else {
                                throw new IllegalArgumentException("Unexpected message type: " + message.getClass().toString());
                            }
                        }
                        if (!usingTimeout || startTime <= 0L || (timeElapsed = (currentTime = new Date().getTime()) - startTime) <= (long)SjmsBatchConsumer.this.completionTimeout) continue;
                        break;
                    }
                    LOG.info("Shutdown signal received - rolling batch back");
                    session.rollback();
                    break block0;
                }
                this.process(aggregatedExchange, session);
            }
        }

        private long getReceiveWaitTime(long timeElapsed) {
            long timeRemaining = this.getTimeRemaining(timeElapsed);
            if (timeRemaining <= 0L) {
                timeRemaining = 1L;
            }
            long waitTime = timeRemaining > (long)SjmsBatchConsumer.this.pollDuration ? (long)SjmsBatchConsumer.this.pollDuration : timeRemaining;
            LOG.debug("waiting for {}", (Object)waitTime);
            return waitTime;
        }

        private long getTimeRemaining(long timeElapsed) {
            long timeRemaining = (long)SjmsBatchConsumer.this.completionTimeout - timeElapsed;
            if (LOG.isDebugEnabled() && timeElapsed > 0L) {
                LOG.debug("Time remaining this batch: {}", (Object)timeRemaining);
            }
            return timeRemaining;
        }

        private void process(Exchange exchange, Session session) {
            int id = BATCH_COUNT.getAndIncrement();
            int batchSize = (Integer)exchange.getProperty("CamelSjmsBatchSize", Integer.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing batch[" + id + "]:size=" + batchSize + ":total=" + MESSAGE_RECEIVED.addAndGet(batchSize));
            }
            SessionCompletion sessionCompletion = new SessionCompletion(session);
            exchange.addOnCompletion((Synchronization)sessionCompletion);
            try {
                SjmsBatchConsumer.this.processor.process(exchange);
                long total = MESSAGE_PROCESSED.addAndGet(batchSize);
                LOG.debug("Completed processing[{}]:total={}", (Object)id, (Object)total);
            }
            catch (Exception e) {
                LOG.error("Error processing exchange: {}", (Object)e.getMessage());
            }
        }
    }
}

