/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servletlistener;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.servletlistener.CamelContextLifecycle;
import org.apache.camel.component.servletlistener.ServletCamelContext;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelServletContextListener<R extends Registry>
implements ServletContextListener {
    public static ServletCamelContext instance;
    public static final String CAMEL_CONTEXT_KEY = "CamelContext";
    protected static final Logger LOG;
    protected ServletCamelContext camelContext;
    protected CamelContextLifecycle<R> camelContextLifecycle;
    protected boolean test;
    protected R registry;

    public void contextInitialized(ServletContextEvent sce) {
        LOG.info("CamelContextServletListener initializing ...");
        try {
            this.registry = this.createRegistry();
            this.camelContext = new ServletCamelContext((Registry)this.registry, sce.getServletContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating CamelContext.", e);
        }
        Map<String, Object> map = this.extractInitParameters(sce);
        String test = (String)map.remove("test");
        if (test != null && "true".equalsIgnoreCase(test)) {
            this.test = true;
        }
        LOG.trace("In test mode? {}", (Object)this.test);
        try {
            this.initPropertyPlaceholder(this.camelContext, map);
            this.initJmx(this.camelContext, map);
            this.initCamelContext(this.camelContext, map);
            if (!map.isEmpty()) {
                IntrospectionSupport.setProperties((Object)((Object)this.camelContext), map);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting init parameters on CamelContext.", e);
        }
        String lifecycle = (String)map.remove("CamelContextLifecycle");
        if (lifecycle != null) {
            try {
                Class clazz = CastUtils.cast((Class)this.camelContext.getClassResolver().resolveMandatoryClass(lifecycle, CamelContextLifecycle.class));
                this.camelContextLifecycle = (CamelContextLifecycle)this.camelContext.getInjector().newInstance(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error creating CamelContextLifecycle class with name " + lifecycle, e);
            }
        }
        try {
            if (this.camelContextLifecycle != null) {
                this.camelContextLifecycle.beforeAddRoutes(this.camelContext, this.registry);
            }
        }
        catch (Exception e) {
            LOG.error("Error before adding routes to CamelContext.", (Throwable)e);
            throw new RuntimeException("Error before adding routes to CamelContext.", e);
        }
        List<Object> routes = this.extractRoutes(map);
        for (Object route : routes) {
            if (route instanceof RouteBuilder) {
                try {
                    this.camelContext.addRoutes((RoutesBuilder)route);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error adding route " + route, e);
                }
            }
            if (route instanceof Set) {
                for (Object routesBuilder : (Set)route) {
                    try {
                        this.camelContext.addRoutes((RoutesBuilder)routesBuilder);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error adding route " + routesBuilder, e);
                    }
                }
                continue;
            }
            if (route instanceof RoutesDefinition) {
                try {
                    this.camelContext.addRouteDefinitions(((RoutesDefinition)route).getRoutes());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error adding route(s) " + route, e);
                }
            }
            if (route instanceof RouteDefinition) {
                try {
                    this.camelContext.addRouteDefinition((RouteDefinition)route);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error adding route(s) " + route, e);
                }
            }
            throw new IllegalArgumentException("Unsupported route: " + route);
        }
        if (!map.isEmpty()) {
            LOG.info("There are {} ServletContext init parameters, unknown to Camel. Maybe they are used by other frameworks? [{}]", (Object)map.size(), map);
        }
        try {
            if (this.camelContextLifecycle != null) {
                this.camelContextLifecycle.afterAddRoutes(this.camelContext, this.registry);
            }
        }
        catch (Exception e) {
            LOG.error("Error after adding routes to CamelContext.", (Throwable)e);
            throw new RuntimeException("Error after adding routes to CamelContext.", e);
        }
        try {
            if (this.camelContextLifecycle != null) {
                this.camelContextLifecycle.beforeStart(this.camelContext, this.registry);
            }
            this.camelContext.start();
            if (this.camelContextLifecycle != null) {
                this.camelContextLifecycle.afterStart(this.camelContext, this.registry);
            }
        }
        catch (Exception e) {
            LOG.error("Error starting CamelContext.", (Throwable)e);
            throw new RuntimeException("Error starting CamelContext.", e);
        }
        if (this.test) {
            instance = this.camelContext;
        }
        sce.getServletContext().setAttribute(CAMEL_CONTEXT_KEY, (Object)this.camelContext);
        LOG.info("CamelContextServletListener initialized");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOG.info("CamelContextServletListener destroying ...");
        if (this.camelContext != null) {
            try {
                if (this.camelContextLifecycle != null) {
                    this.camelContextLifecycle.beforeStop(this.camelContext, this.registry);
                }
                this.camelContext.stop();
                if (this.camelContextLifecycle != null) {
                    this.camelContextLifecycle.afterStop(this.camelContext, this.registry);
                }
            }
            catch (Exception e) {
                LOG.warn("Error stopping CamelContext. This exception will be ignored.", (Throwable)e);
            }
        }
        this.camelContext = null;
        this.registry = null;
        instance = null;
        sce.getServletContext().removeAttribute(CAMEL_CONTEXT_KEY);
        LOG.info("CamelContextServletListener destroyed");
    }

    protected abstract R createRegistry() throws Exception;

    private Map<String, Object> extractInitParameters(ServletContextEvent sce) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration names = sce.getServletContext().getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = sce.getServletContext().getInitParameter(name);
            if (!ObjectHelper.isNotEmpty((Object)value)) continue;
            Object target = value;
            if (value.startsWith("#")) {
                value = value.substring(1);
                target = this.lookupRegistryByName(value);
                LOG.debug("Resolved the servlet context's initialization parameter {} to {}", (Object)value, target);
            }
            map.put(name, target);
        }
        return map;
    }

    private void initPropertyPlaceholder(ServletCamelContext camelContext, Map<String, Object> parameters) throws Exception {
        Map properties = IntrospectionSupport.extractProperties(parameters, (String)"propertyPlaceholder.");
        if (properties != null && !properties.isEmpty()) {
            PropertiesComponent pc = new PropertiesComponent();
            IntrospectionSupport.setProperties((Object)pc, (Map)properties);
            if (!properties.isEmpty()) {
                throw new IllegalArgumentException("Error setting propertyPlaceholder parameters on CamelContext. There are " + properties.size() + " unknown parameters. [" + properties + "]");
            }
            camelContext.addComponent("properties", (Component)pc);
        }
    }

    private void initJmx(ServletCamelContext camelContext, Map<String, Object> parameters) throws Exception {
        Map properties = IntrospectionSupport.extractProperties(parameters, (String)"jmx.");
        if (properties != null && !properties.isEmpty()) {
            String disabled = (String)properties.remove("disabled");
            boolean disableJmx = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)(disabled != null ? disabled : "false"));
            if (disableJmx) {
                LOG.info("JMXAgent disabled");
                camelContext.getLifecycleStrategies().clear();
                camelContext.setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy());
            } else {
                String loadStatisticsEnabled;
                Boolean statisticsEnabled;
                LOG.info("JMXAgent enabled");
                DefaultManagementAgent agent = new DefaultManagementAgent((CamelContext)camelContext);
                IntrospectionSupport.setProperties((Object)agent, (Map)properties);
                ManagedManagementStrategy managementStrategy = new ManagedManagementStrategy((CamelContext)camelContext, (ManagementAgent)agent);
                camelContext.setManagementStrategy((ManagementStrategy)managementStrategy);
                camelContext.getLifecycleStrategies().clear();
                camelContext.addLifecycleStrategy((LifecycleStrategy)new DefaultManagementLifecycleStrategy((CamelContext)camelContext));
                boolean onlyId = agent.getOnlyRegisterProcessorWithCustomId() != null && agent.getOnlyRegisterProcessorWithCustomId() != false;
                camelContext.getManagementStrategy().onlyManageProcessorWithCustomId(onlyId);
                String statisticsLevel = (String)properties.remove("statisticsLevel");
                if (statisticsLevel != null) {
                    camelContext.getManagementStrategy().setStatisticsLevel(ManagementStatisticsLevel.valueOf((String)statisticsLevel));
                }
                if ((statisticsEnabled = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((loadStatisticsEnabled = (String)properties.remove("loadStatisticsEnabled")) != null ? loadStatisticsEnabled : "true"))) != null) {
                    camelContext.getManagementStrategy().setLoadStatisticsEnabled(statisticsEnabled.booleanValue());
                }
            }
            if (!properties.isEmpty()) {
                throw new IllegalArgumentException("Error setting jmx parameters on CamelContext. There are " + properties.size() + " unknown parameters. [" + properties + "]");
            }
        }
    }

    private void initCamelContext(ServletCamelContext camelContext, Map<String, Object> parameters) throws Exception {
        Map properties;
        String threadNamePattern;
        String managementNamePattern;
        String useBreadcrumb;
        String useMDCLogging;
        String autoStartup;
        String errorHandlerRef;
        String handleFault;
        String delayer;
        String trace;
        String streamCache;
        String messageHistory = (String)parameters.remove("messageHistory");
        if (messageHistory != null) {
            camelContext.setMessageHistory(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)messageHistory));
        }
        if ((streamCache = (String)parameters.remove("streamCache")) != null) {
            camelContext.setStreamCaching(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)streamCache));
        }
        if ((trace = (String)parameters.remove("trace")) != null) {
            camelContext.setTracing(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)trace));
        }
        if ((delayer = (String)parameters.remove("delayer")) != null) {
            camelContext.setDelayer(CamelContextHelper.parseLong((CamelContext)camelContext, (String)delayer));
        }
        if ((handleFault = (String)parameters.remove("handleFault")) != null) {
            camelContext.setHandleFault(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)handleFault));
        }
        if ((errorHandlerRef = (String)parameters.remove("errorHandlerRef")) != null) {
            camelContext.setErrorHandlerBuilder((ErrorHandlerFactory)new ErrorHandlerBuilderRef(errorHandlerRef));
        }
        if ((autoStartup = (String)parameters.remove("autoStartup")) != null) {
            camelContext.setAutoStartup(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)autoStartup));
        }
        if ((useMDCLogging = (String)parameters.remove("useMDCLogging")) != null) {
            camelContext.setUseMDCLogging(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)useMDCLogging));
        }
        if ((useBreadcrumb = (String)parameters.remove("useBreadcrumb")) != null) {
            camelContext.setUseBreadcrumb(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)useBreadcrumb));
        }
        if ((managementNamePattern = (String)parameters.remove("managementNamePattern")) != null) {
            camelContext.getManagementNameStrategy().setNamePattern(managementNamePattern);
        }
        if ((threadNamePattern = (String)parameters.remove("threadNamePattern")) != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(threadNamePattern);
        }
        if ((properties = IntrospectionSupport.extractProperties(parameters, (String)"properties.")) != null && !properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                camelContext.getProperties().put(entry.getKey(), "" + entry.getValue());
            }
        }
    }

    private List<Object> extractRoutes(Map<String, Object> map) {
        ArrayList<Object> answer = new ArrayList<Object>();
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().toLowerCase(Locale.UK).startsWith("routebuilder")) continue;
            names.add(entry.getKey());
            String value = (String)entry.getValue();
            Iterator it = ObjectHelper.createIterator((Object)value);
            while (it.hasNext()) {
                value = (String)it.next();
                if (!ObjectHelper.isNotEmpty((Object)value)) continue;
                value = value.trim();
                LinkedHashSet<RouteBuilder> target = null;
                if (value.startsWith("#")) {
                    value = value.substring(1);
                    target = this.lookupRegistryByName(value);
                } else {
                    if (ResourceHelper.hasScheme((String)value)) {
                        InputStream is = null;
                        try {
                            is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.camelContext.getClassResolver(), (String)value);
                            target = this.camelContext.loadRoutesDefinition(is);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error loading routes from resource: " + value, e);
                        }
                        finally {
                            IOHelper.close((Closeable)is, (String)entry.getKey(), (Logger)LOG);
                        }
                    }
                    if (value.startsWith("packagescan:")) {
                        String path = value.substring(12);
                        Set classes = this.camelContext.getPackageScanClassResolver().findImplementations(RouteBuilder.class, new String[]{path});
                        if (!classes.isEmpty()) {
                            LinkedHashSet<RouteBuilder> builders;
                            target = builders = new LinkedHashSet<RouteBuilder>();
                            for (Class clazz : classes) {
                                try {
                                    RouteBuilder route = (RouteBuilder)this.camelContext.getInjector().newInstance(clazz);
                                    builders.add(route);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Error creating RouteBuilder " + clazz, e);
                                }
                            }
                        }
                    } else {
                        try {
                            Class clazz = this.camelContext.getClassResolver().resolveMandatoryClass(value, RouteBuilder.class);
                            target = this.camelContext.getInjector().newInstance(clazz);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error creating RouteBuilder " + value, e);
                        }
                    }
                }
                if (target == null) continue;
                answer.add(target);
            }
        }
        for (String name : names) {
            map.remove(name);
        }
        return answer;
    }

    private Object lookupRegistryByName(String name) {
        return this.registry.lookupByName(name);
    }

    static {
        LOG = LoggerFactory.getLogger(CamelServletContextListener.class);
    }
}

