/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;

public final class XStreamUtils {
    private static final String PERMISSIONS_PROPERTY_KEY = "org.apache.camel.xstream.permissions";
    private static final String PERMISSIONS_PROPERTY_DEFAULT = "-*,java.lang.*,java.util.*";

    private XStreamUtils() {
    }

    public static void addPermissions(XStream xstream, String permissions) {
        for (String pterm : permissions.split(",")) {
            boolean aod;
            if ((pterm = pterm.trim()).startsWith("-")) {
                aod = false;
                pterm = pterm.substring(1);
            } else {
                aod = true;
                if (pterm.startsWith("+")) {
                    pterm = pterm.substring(1);
                }
            }
            TypePermission typePermission = null;
            if ("*".equals(pterm)) {
                typePermission = AnyTypePermission.ANY;
            } else if (pterm.indexOf(42) < 0) {
                typePermission = new ExplicitTypePermission(new String[]{pterm});
            } else if (pterm.length() > 0) {
                typePermission = new WildcardTypePermission(new String[]{pterm});
            }
            if (typePermission == null) continue;
            if (aod) {
                xstream.addPermission(typePermission);
                continue;
            }
            xstream.denyPermission(typePermission);
        }
    }

    public static void addDefaultPermissions(XStream xstream) {
        XStreamUtils.addPermissions(xstream, System.getProperty(PERMISSIONS_PROPERTY_KEY, PERMISSIONS_PROPERTY_DEFAULT));
    }
}

